#include "v3.h"

V3::V3(float x, float y, float z) {

	xyz[0] = x;
	xyz[1] = y;
	xyz[2] = z;

}

V3 V3::operator+(V3 v1) {

	V3 ret;
	V3 &v0 = (*this);
	for (int i = 0; i < 3; i++) {
		ret[i] = v0[i] + v1[i];
	}

	return ret;

}

V3 V3::operator-(V3 v1) {

	V3 ret;
	V3 &v0 = (*this);
	for (int i = 0; i < 3; i++) {
		ret[i] = v0[i] - v1[i];
	}

	return ret;

}

ostream& operator<<(ostream &ostr, V3 v) {

	return ostr << v[0] << " " << v[1] << " " << v[2];

}



float& V3::operator[](int i) {

	return xyz[i];

}

float V3::operator*(V3 v1) {

	V3 &v0 = *this;

	float ret = v0[0] * v1[0] + v0[1] * v1[1] + v0[2] * v1[2];

	return ret;


}

float V3::Length() {

	V3 &v0 = *this;
	float ret = sqrtf(v0*v0);
	return ret;

}

V3 V3::operator/(float scf) {

	V3 ret;
	V3 &v = *this;
	ret[0] = v[0] / scf;
	ret[1] = v[1] / scf;
	ret[2] = v[2] / scf;
	return ret;

}

V3 V3::operator*(float scf) {

	V3 ret;
	V3 &v = *this;
	ret[0] = v[0] * scf;
	ret[1] = v[1] * scf;
	ret[2] = v[2] * scf;
	return ret;

}


V3 V3::Normalized() {

	V3 &v = *this;
	return v / v.Length();

}

