#include "GL/glew.h"

#include "scene.h"
#include "v3.h"
#include "m33.h"

Scene *scene;


#include <iostream>
#include <fstream>
#include <strstream>

using namespace std;


Scene::Scene() {


	int u0 = 20;
	int v0 = 40;
	int h = 400;
	int w = 600;
	fb = new FrameBuffer(u0, v0, w, h);
	fb->position(u0, v0);
	fb->label("SW Framebuffer");
	fb->show();
	fb->redraw();

	gui = new GUI();
	gui->show();
	gui->uiw->position(u0, v0 + fb->h + v0);

}


void Scene::DBG() {

	{
		V3 v0(13.0f, 0.0f, 0.0f);
		V3 v1(0.0f, 1.0f, 0.0f);
		V3 v2(0.0f, 0.0f, 1.0f);
		M33 m(v0, v1, v2);
		cerr << m[0] << endl;
		cerr << m[1] << endl;
		cerr << m[2] << endl;
		cerr << m[0][0] << endl;
		m[0][0] = -1.0f;
		cerr << m[0][0] << endl;
		cerr << m*v2 << endl;
		return;
	}

	{
		V3 v(1.0f, 2.0f, 3.0f);
		cerr << "vector v: " << v << endl;
		cerr << "length of v: " << v.Length() << endl;
		cerr << "vx3: " << v*3.0f << endl;
		cerr << "v.Normalized(): " << v.Normalized() << endl;
		cerr << v.Normalized().Length() << endl;
		return;
	}

	int stepsN = 10000;
	for (int si = 0; si < stepsN; si++) {
		fb->Set(0xFFFFFFFF);
		int v = fb->h / 2;
		for (int u = 100; u < 200; u++) {
			fb->SetSafe(u + si, v, 0xFF000000);
		}
		fb->redraw();
		Fl::check();
	}
	return;


	V3 v0(1.0f, 2.0f, 3.0f);
	V3 v1(2.0f, 4.0f, 6.0f);
	V3 v;
	v = v0 + v1;
	return;


	fb->SetChecker(32, 0xFF000000, 0xFFFFFFFF);
	fb->redraw();
	return;


	fb->Set(0xFF00FF00);
	fb->redraw();
	return;

	for (int i = 0; i < fb->w*fb->h; i++) {
		fb->pix[i] = 0xFF0000FF;
	}
	
	fb->redraw();

	cerr << endl;
	cerr << "INFO: pressed DBG button on GUI" << endl;

}

void Scene::NewButton() {
	cerr << "INFO: pressed New button on GUI" << endl;
}

