#include "ppc.h"
#include "M33.h"

PPC::PPC(float hfov, int _w, int _h) {

	w = _w;
	h = _h;
	C = V3(0.0f, 0.0f, 0.0f);
	a = V3(1.0f, 0.0f, 0.0f);
	b = V3(0.0f, -1.0f, 0.0f);
	float hfovr = hfov *3.1415926f / 180.0f;
	c = V3(-(float)w / 2.0f, (float)h / 2.0f, 
		-(float)w / (2.0f*tan(hfovr / 2.0f)));

}


int PPC::Project(V3 P, V3& PP) {

	int ret = 1;

	M33 M; 
	M.SetColumn(0, a);
	M.SetColumn(1, b);
	M.SetColumn(2, c);

	V3 q = M.Inverted()*(P - C);

	if (q[2] <= 0.0f)
		return 0;

	PP[0] = q[0] / q[2];
	PP[1] = q[1] / q[2];
	PP[2] = 1.0f / q[2];

	return ret;

}
