#include "GL/glew.h"

#include "scene.h"
#include "v3.h"
#include "m33.h"
#include "ppc.h"
#include "TM.h"

Scene *scene;


#include <iostream>
#include <fstream>
#include <strstream>

using namespace std;


Scene::Scene() {


	int u0 = 20;
	int v0 = 40;
	int h = 400;
	int w = 600;
	fb = new FrameBuffer(u0, v0, w, h);
	fb->position(u0, v0);
	fb->label("SW Framebuffer");
	fb->show();
	fb->redraw();

	gui = new GUI();
	gui->show();
	gui->uiw->position(u0, v0 + fb->h + v0);

}


void Scene::DBG() {

	cerr << endl;

	{
		V3 p0(10.0f, 200.0f, 0.0f);
		V3 p1(210.0f, 200.0f, 0.0f);
		fb->Set(0xFFFFFFFF);
		V3 C0(1.0f, 0.0f, 0.0f);
		V3 C1(0.0f, 1.0f, 0.0f);
		fb->Draw2DSegment(C0, C1, p0, p1);
		fb->redraw();
		return;
	}

	{
		// load triangle mesh
		TM tm;
		tm.LoadBin("geometry/teapot1K.bin");

		tm.Position(V3(0.0f, 0.0f, -150.0f));

		// create camera
		float hfov = 60.0f;
		PPC ppc(hfov, fb->w, fb->h);
		// translate backwards to teapot
//		ppc.Translate(V3(0.0f, 0.0f, 250.0f));
		// clear framebuffer
		fb->Set(0xFFFFFFFF);

		// render mesh with one point per vertex; // no triangles (yet)
		tm.DrawPoints(0xFF000000, 3, &ppc, fb);

		// refresh window
		fb->redraw();

//		return;
		
		// spin the teapot in place (about a vertical axis passing through its center)
		V3 ad(0.0f, 1.0f, 0.0f);
		V3 aO = tm.GetCenter();
		for (int fi = 0; fi < 360; fi++) {
			fb->Set(0xFFFFFFFF);
//			tm.DrawPoints(0xFF000000, 3, &ppc, fb);
			tm.DrawWireFrame(0xFF000000, &ppc, fb);
			fb->redraw();
			Fl::check();
			tm.RotateAboutArbitraryAxis(aO, ad, 1.0f);
		}

		return;



	}

	{
		float hfov = 60.0f;
		PPC ppc(hfov, fb->w, fb->h);
		V3 PL(-5.0f, -5.0f, -20.0f);
		V3 PR(+5.0f, -5.0f, -20.0f);
		V3 PP;

		V3 cube[8];
		V3 cubeCenter(0.0f, 0.0f, -10.0f);
		float a = 2.0f;
		cube[0] = cubeCenter + V3(-a, a, a);
		cube[1] = cube[0] + V3(0.0f, -2.0f*a, 0.0f);
		cube[2] = cube[1] + V3(2.0f*a, 0.0f, 0.0f);
		cube[3] = cube[2] + V3(0.0f, 2.0f*a, 0.0f);

		int framesN = 3000;
		V3 tv(0.001f, 0.0f, 0.0f);
		for (int fi = 0; fi < framesN; fi++) {

			for (int vi = 0; vi < 4; vi++) {
				cube[vi + 4] = cube[vi] + V3(0, 0, -2.0f*a);
			}
			fb->Set(0xFFFFFFFF);
			for (int vi = 0; vi < 8; vi++) {
				V3 PP;
				ppc.Project(cube[vi], PP);
				if (vi < 4)
					fb->DrawPoint2D(PP, 13, 0xFF0000FF);
				else
					fb->DrawPoint2D(PP, 13, 0xFFFF0000);
			}
			fb->redraw();
			Fl::check();
			ppc.Translate(tv);
		}

		return;

		framesN = 1000;
		float tstep = 0.01f;
		for (int fi = 0; fi < framesN; fi++) {
			fb->Set(0xFFFFFFFF);
			ppc.Project(PL, PP);
			fb->DrawPoint2D(PP, 13, 0xFFFF0000);
			ppc.Project(PR, PP);
			fb->DrawPoint2D(PP, 13, 0xFFFF0000);
			fb->redraw();
			Fl::check();
			PL[2] -= tstep;
			PR[2] -= tstep;
		}

		return;

	}

	{
		V3 v0(10.0f, -1.0f, 0.0f);
		V3 v1(3.0f, 1.0f, 2.0f);
		V3 v2(-7.0f, 0.0f, 1.0f);
		M33 m(v0, v1, v2), minv;
		minv = m.Inverted();
		cerr << minv*m.GetColumn(0) << endl;
		cerr << minv*m.GetColumn(1) << endl;
		cerr << minv*m.GetColumn(2) << endl;
		return;


		cerr << m[0][0] << endl;
		m[0][0] = -1.0f;
		cerr << m[0][0] << endl;
		cerr << m*v2 << endl;
		return;
	}

	{
		V3 v(1.0f, 2.0f, 3.0f);
		cerr << "vector v: " << v << endl;
		cerr << "length of v: " << v.Length() << endl;
		cerr << "vx3: " << v*3.0f << endl;
		cerr << "v.Normalized(): " << v.Normalized() << endl;
		cerr << v.Normalized().Length() << endl;
		return;
	}

	int stepsN = 10000;
	for (int si = 0; si < stepsN; si++) {
		fb->Set(0xFFFFFFFF);
		int v = fb->h / 2;
		for (int u = 100; u < 200; u++) {
			fb->SetSafe(u + si, v, 0xFF000000);
		}
		fb->redraw();
		Fl::check();
	}
	return;


	V3 v0(1.0f, 2.0f, 3.0f);
	V3 v1(2.0f, 4.0f, 6.0f);
	V3 v;
	v = v0 + v1;
	return;


	fb->SetChecker(32, 0xFF000000, 0xFFFFFFFF);
	fb->redraw();
	return;


	fb->Set(0xFF00FF00);
	fb->redraw();
	return;

	for (int i = 0; i < fb->w*fb->h; i++) {
		fb->pix[i] = 0xFF0000FF;
	}
	
	fb->redraw();

	cerr << endl;
	cerr << "INFO: pressed DBG button on GUI" << endl;

}

void Scene::NewButton() {
	cerr << "INFO: pressed New button on GUI" << endl;
}

