#pragma once

#include <ostream>

using namespace std;

class V3 {
public:
	float xyz[3];
	V3(float x, float y, float z);
	V3() {};
	V3 operator+(V3 v1);
	V3 operator-(V3 v1);
	float& operator[](int i);
	friend ostream& operator<<(ostream &ostr, V3 v);
	float operator*(V3 v1);
	float Length();
	V3 operator/(float scf);
	V3 operator*(float scf);
	V3 Normalized();
	V3 operator^(V3 v1);
	V3 RotateThisPointAboutArbitraryAxis(V3 Oa, V3 ad, float theta);
	V3 RotateThisVectorAboutArbitraryAxis(V3 ad, float theta);
	unsigned int GetColor();
	void SetColor(unsigned int color);
	// light "this" color based on normal and light direction and ka
	V3 Light(V3 n, V3 ld, float ka);
	V3 Reflect(V3 l);
};

class AABB {
public:
	V3 c0, c1;
	AABB(V3 P) { c0 = c1 = P; };
	void AddPoint(V3 P);

};