#pragma once

#include "v3.h"
class FrameBuffer;

class PPC {
public:
	V3 a, b, c, C;
	int w, h;
	PPC() {};
	PPC(float hfov, int _w, int _h);
	int Project(V3 P, V3& PP);
	void Translate(V3 tv);
	V3 GetVD();
	float GetF();
	void Visualize(PPC *visPPC, FrameBuffer *fb, float visF);
	void Pan(float theta);
	void Pose(V3 newC, V3 LAP, V3 upv);
	V3 Unproject(int u, int v, float _1w);
	void SetHWInstrinsics();
	void SetHWExtrinsics();
};