#pragma once

#include "gui.h"
#include "framebuffer.h"
#include "tm.h"
#include "gfb.h"
#include "CGInterface.h"


class Scene {
public:

	CGInterface *cgi;
	ShaderOneInterface *soi;

	GUI *gui;
	FrameBuffer *fb, *fb3, *smfb, *hwfb, *gpufb;
	GFB *gfb;
	V3 L;
	float specc;
	TM *tms;
	int tmsN;
	FrameBuffer *texts;
	PPC *ppc, *ppc3, *smppc;
	Scene();
	void DBG();
	void NewButton();
	void Render(FrameBuffer *fb, PPC *ppc);
	void RenderPT(FrameBuffer *fb0, PPC *ppc0, FrameBuffer *fb, PPC *ppc);
	void RenderRT(FrameBuffer *fb, PPC *ppc);
	void Intersect(V3 Vs[3], V3 O, V3 ray, V3 &abc, float &t);
	unsigned int TraceRay(int orderi, V3 O, V3 ray, V3 &rO, V3 &rray);
	void RenderAll();
	void ShadowMapSetup();
	void RenderHW();
	void RenderGPU();

	float morphFraction;
	void PTMDemo();
	void VizErrorPT(int ftpsN, V3 *uv, V3 *xyz, PPC *ppc, FrameBuffer *vizFB);
	float ErrorPT(int ftpsN, V3 *uv, V3 *xyz, PPC *ppc);
	void BlendErrorViz(FrameBuffer *fb0, FrameBuffer *fb1);
	PPC *ppcPTM;
	FrameBuffer *fbPTM;


	// panorama demo
	void PanoDemo();
	FrameBuffer *lfb, *rfb, *canfb;
	PPC *lppc, *rppc, *canppc;
	void VisualizeInCanvas(FrameBuffer *tovfb, PPC *tovppc, 
		FrameBuffer *cfb, PPC *cppc);
	float StitchingError(FrameBuffer *fb0, PPC *ppc0,
		FrameBuffer *fb1, PPC *ppc1);

};

extern Scene *scene;