#!/usr/local/bin/python3

import vtk
import sys
import os

# vtkpython merge.py ftle_fwd.nrrd heval2.nrrd merged.nrrd

reader = vtk.vtkNrrdReader()
reader.SetFileName(sys.argv[1])
reader.Update()

reader2 = vtk.vtkNrrdReader()
reader2.SetFileName(sys.argv[2])
reader2.Update()

ftle = reader.GetOutput()
ftle.GetPointData().GetScalars().SetName("ftle")
heval = reader2.GetOutput()
heval.GetPointData().GetScalars().SetName("lambda_min")
ftle.GetPointData().AddArray(heval.GetPointData().GetScalars())

writer = vtk.vtkXMLImageDataWriter()
writer.SetInputData(ftle)
writer.SetFileName(sys.argv[3])
writer.Write()