/* NAT_net.h - protocol declarations used by the core component */

/* Ethernet packet header */
typedef struct eth_s {
	unsigned char e_dst[6];
	unsigned char e_src[6];
	unsigned short e_type;
	unsigned short data[1];
} eth;

/* ARP packet header      */
typedef struct arp_s {
	unsigned short ar_hrd;
	unsigned short ar_pro;
	unsigned char ar_hln;
	unsigned char ar_pln;
	unsigned short ar_op;
	unsigned char ar_sha[6];
	/* declared as two shorts for alignment */
	unsigned short  ar_spa1;
	unsigned short  ar_spa2;
	unsigned char ar_tha[6];
	unsigned int  ar_tpa;
} arp;

/* IP packet header       */
typedef struct ip_s {
	unsigned char ip_v : 4;
	unsigned char ip_hl : 4;
	unsigned char ip_tos;
	unsigned short ip_len;
	unsigned short ip_id;
	unsigned short ip_frag;
	unsigned char ip_ttl;
	unsigned char ip_p;
	unsigned short ip_sum;
	unsigned int ip_src;
	unsigned int ip_dst;
	unsigned int data[1];
} ip;

/* ICMP packet header     */
typedef struct icmp_s {
	unsigned char icmp_type;
	unsigned char icmp_code;
	unsigned short icmp_cksum;
	unsigned short icmp_id;
	unsigned short icmp_seq;
	unsigned int data[1];
} icmp;

/* TCP packet header      */
typedef struct tcp_s {
	unsigned short tcp_sport;
	unsigned short tcp_dport;
	unsigned int tcp_seq;
	unsigned int tcp_ack;
	unsigned char tcp_offset;
	unsigned char tcp_code;
	unsigned short tcp_window;
	unsigned short tcp_cksum;
	unsigned short tcp_urgptr;
	unsigned int data[1];
} tcp;

/* UDP packet header      */
typedef struct udp_s {
	unsigned short udp_sport;
	unsigned short udp_dport;
	unsigned short udp_len;
	unsigned short udp_cksum;
} udp;

/* Transmit request structure */
typedef struct tx_req_s {
	unsigned int valid : 1;
	unsigned int reserved : 3;
	unsigned int port : 4;
	unsigned int buff_handle : 24;
} ix_tx_req;

