/* NAT_scratch_rings.h - constants used for Scratch Memory rings */

/* Ring used between the PACKET_RX and NAT microblocks */

#define	PKT_RX_TO_NAT_SCR_RING		4	
#define	PKT_RX_TO_NAT_SCR_RING_SIZE	IX_SCRATCH_RING_SIZE_1K


/* First ring for communicating between NAT and Packet TX microblocks */

#define	PACKET_TX_SCR_RING_0		6
#define	PACKET_TX_SCR_RING_0_SIZE	IX_SCRATCH_RING_SIZE_256


/* Second ring for communicating between NAT and Packet TX microblocks */

#define	PACKET_TX_SCR_RING_1		7
#define	PACKET_TX_SCR_RING_1_SIZE	IX_SCRATCH_RING_SIZE_256


/* Third ring for communicating between NAT and Packet TX microblocks */

#define 	PACKET_TX_SCR_RING_2		8
#define 	PACKET_TX_SCR_RING_2_SIZE	IX_SCRATCH_RING_SIZE_256

/* Fourth ring for communicating between NAT and Packet TX microblocks */

#define	PACKET_TX_SCR_RING_3		9
#define	PACKET_TX_SCR_RING_3_SIZE	IX_SCRATCH_RING_SIZE_256
