/*  dl_source.uc - macros for RX to NAT microblock communication */

/**************************************************************/
/* This file is adapted from examples in the Intel SDK and    */
/* parts of the code are covered by Intel copyright.  You     */
/* only have permission to use this file if you have obtained */
/* a copy of the SDK from Intel.                              */
/**************************************************************/

#ifndef __DL_SOURCE_UC__
#define __DL_SOURCE_UC__

#ifdef _DEBUG_COUNTERS_
.reg @pkt_rx_enqueued				
#endif // _DEBUG_COUNTERS_

#include <stdmac.uc>
#include <sig_macros.uc>
#include <dispatch_loop.h>
#include <dl_misc.uc>

#define	RX_TO_FUNC_MSG_SIZE		5		// 5 longwords

#if (DL_RING_NUMBER > 11)
#error "For Ring Number Greater than 11, we cannot use the SCR_Ring#_Full input state. Check RING_NUMBER"
#else
#define_eval	DL_RING_FULL			SCR_Ring/**/DL_RING_NUMBER/**/_Full	
#endif

.reg 	global	dl_ring			// scratch ring number for pos rx ==>ipv4. This can be made an absolut register
.reg 	global	dl_buf_handle		// The current Buffer handle.
.reg	global	dl_eop_buf_handle	// For large packets, this is the last buffer in the chain
.reg	global	dl_next_block		// Next block that should process the buffer/packet
.reg    global  dl_exception_reg 	// Exception register used to send pkts to CORE
.set            dl_exception_reg

///////////////////////////////////////////////////////////////////////////////
// _dl_pos_sink_init:
//	 	Description: 
//			Initialisation for POS dl_sink. Should be called before using dl_sink.
//			It simply sets a global variable dl_ring to the corresponding ring number
//			This will later save one instruction in dl_sink (for POS).
//
//			This macro is called by POS RX (packet_rx) microblock.
//
#macro _dl_pos_sink_init[]
.begin

	alu_shf[dl_ring, --, B, DL_RING_NUMBER, <<2]	; ring number to be used in get/put 

.end
#endm

///////////////////////////////////////////////////////////////////////////////
// dl_sink:
//	 	Description: 
//			Called by POS RX to handover the packet to the next block (NAT) in the
//			ingress pipeline.
//			
//			This macro will produce the following on to the scratch ring.
//			dl_buf_handle		// The current buffer containing SOP 
//			dl_eop_buf_handle	// for large packets, the buffer containing EOP. Otherwise NULL
//			meta1			// Long Word 1 from the Meta data (starting from 0)
//			meta2			// Long Word 2 from the Meta Data
//			meta3			// Long Word 3 from the meta data
//
//			This info will be used by the NAT block
//
//			Note:
//			sig_mask is a bit mask of signals to wait on. This is passed in a regiter.
//			If there is no need to wait for any signal, pass SIG_NONE. 
//
//		Inputs:
//			wxfer_prefix:		SRAM Write Transfer Register name prefix (using xbuf_alloc).
//			req_sig			:	signal to be used in the I/O (scratch put)
//			sig_mask		:	What to do with I/O operation - 
//								- wait for signal(s) as specified by sig_mask (register)
//								- do not wait for signal, just return (SIG_NONE - constant)
//			The following Global variables will also act as inputs.
//			dl_next_block		- IX_EXCEPTION, for exception packets
//						- BID_NEXT_BLOCK, block ID of the next block to handle this packet.
//			dl_buf_handle		: Buffer handle of the buffer in the start of chain (contianinf SOP)
//			dl_buf_eop_handle	: Buffer handle of the last buffer in the chain
//
#macro dl_sink[wxfer_prefix, req_sig, sig_mask]
.begin

	// We need to act only on EOP. otherwise just return.

	br=byte[dl_next_block, 0, BID_NEXT_BLOCK, sink_it#], defer[3]

	// Move required data to xfer registers in the defer slot.

	move[wxfer_prefix/**/0, dl_buf_handle]		; dl_buf_handle -> xfer0
	move[wxfer_prefix/**/1, dl_eop_buf_handle]	; dl_eop_buf_handle -> xfer1
	move[wxfer_prefix/**/3, dl_meta[2]]		; LW2 of meta data -> xfer3.


check_exception#:

	br!=byte[dl_next_block, 0, IX_EXCEPTION, nothing_to_do#]
	
	// Do Exception processing here.
	// For now just drop the packet.

drop_pkt#:

	alu[@pkt_rx_drop, @pkt_rx_drop, +, 1]
	
	//sram counter increment for drop
	.begin
	.reg port_in
	dl_meta_get_input_port( port_in )
	_packet_rx_incr_counter(port_in, PACKET_PKTS_DROPPED)
	.end

	// Drop the packet. Two cases to handle. Single buffer or a bufffer chain.
	// It is determined by looking at the dl_eop_buf_handle

	alu[--, dl_eop_buf_handle, -, IX_NULL]	; if dl_eop_buf_handle == IX_NULL
	beq[drop_single_buffer#]		; then it is single buffer.

	dl_drop_buffer_chain[dl_buf_handle, dl_eop_buf_handle]	; otherwise, buffer chain.
	br[nothing_to_do#]

drop_single_buffer#:

	dl_drop_buffer[dl_buf_handle]
	br[nothing_to_do#]

sink_it#:
	// Check if the ring is full and then produce the data 
	// onto the ring. If ring full, loop.

	br_inp_state[DL_RING_FULL, sink_it#]	

	// ring Not Full. Put the packet on the ring.

	// fillup 2nd LW of scratch data

	move[wxfer_prefix/**/2, dl_meta[1]]	; buffersize:offset
	move[wxfer_prefix/**/4, dl_meta[3]]	; inport

	// put 5 words on the ring
	scratch[put, wxfer_prefix/**/0, 0, dl_ring, 5], sig_done[req_sig]
	alu[@pkt_rx_enqueued, @pkt_rx_enqueued, +, 1]

#if (!streq(sig_mask, 'SIG_NONE'))
	// Add the signal to the signal mask on which to wait
	alu_shf[sig_mask, sig_mask, OR, 1, <<&req_sig]		
#endif

nothing_to_do#:

#if (!streq(sig_mask, 'SIG_NONE'))
	local_csr_wr[active_ctx_wakeup_events, sig_mask]
	ctx_arb[--]
#endif

	
.end
#endm

#endif	// __DL_SOURCE_UC__
