/* NAT_shared_defs.h - constants shared by microcode and core code	*/

#define NAT_DEF_MAJOR_NUMBER 50	/* Major number of NAT pseudo-device	*/

#define	NAT_DRIVER_NAME	"NAT"  	/* Name of driver for NAT pseudo-device	*/

#define NAT_DEV_FILE "/dev/NAT"	/* File name for NAT pseudo-device	*/

#define PORTS_NUM 2		/* Number of network interfaces		*/

#define NAT_IFC 0		/* External interfaces to outside world	*/

#define GW_IP 0xC0A80064	/* Router's IP address (192.168.0.100)	*/

#define NAT_CC_ID 65		/* ID of core component for exceptions	*/

/* Packet buffer parameters: 64MB of buffers, 2048 bytes per buffer	*/
#define NUM_BUFFERS 32*1024
#define BUF_SIZE 2048

/* Memory channels for free buffer list */
#define BUF_SRAM_CHAN 0
#define BUF_DRAM_CHAN 0

/* Counter sizes.  These are implicitly defined in TX and RX building	*/
/* blocks.  Namely, there are four 4-byte counters per port, which, for	*/
/* three ports gives 4*4*3=48 bytes for each counter region		*/
#define RX_CNTR_SIZE 48
#define TX_CNTR_SIZE 48

/* NAT table size, which must be a power of two */
#define NAT_TABLE_SIZE 128*1024	/* 128K entries */

/* Hash bucket size for NAT table = 2^HASH_BUCKET_SHIFT */
#define HASH_BUCKET_SHIFT 3
#define HASH_BUCKET_SIZE (1<<HASH_BUCKET_SHIFT)

/* NAT table bit mask */
#define NAT_TABLE_BIT_MASK ((NAT_TABLE_SIZE>>HASH_BUCKET_SHIFT)-1)

/* ARP table size, which must be a power of two */
#define ARP_TABLE_SIZE 256

/* ARP table bit mask */
#define ARP_TABLE_BIT_MASK (ARP_TABLE_SIZE-1)

/* Ethernet packet types that are recognized */
#define	ETH_ARP	0x0806	/* ARP */
#define	ETH_IP	0x0800	/* IP  */

/* IP protocol types that are recognized */
#define	IPT_UDP	 17
#define	IPT_TCP	 6
#define	IPT_ICMP 1

/* ICMP message types that are recognized */
#define ICMP_ECHO_REQ 8
#define ICMP_ECHO_REP 0

/* ARP operation types */
#define ARP_REQ 1
#define ARP_REP 2

/* Timer aging interval in ms */
#define AGING_INTERVAL 1000	/* 1 sec */

/* Maximum number of attempts to select a new (unused) NAT port value */
#define NEW_NPORT_ATTEMPS 30

/* Maximum number of attempts to resolve gateway MAC address */
#define GW_MAC_RES_ATTEMPTS 3

/* Number of microengines */
#define ME_NUM 8

/* Size of one microengine cluster */
#define ME_CL_SZ 4

/* Macro to represent Ethernet address as a byte array */
#define ETH2B(X) \
((char*)&(X))[0],((char*)&(X))[1],((char*)&(X))[2],((char*)&(X))[3],\
((char*)&(X))[4],((char*)&(X))[5]

/* Macro to represent IP address as a byte array */
#define IP2B(X) \
((char*)&(X))[0],((char*)&(X))[1],((char*)&(X))[2],((char*)&(X))[3]

