/* WWB_dl.uc - dispatch loop for wwbump program */

/* Constants */

#define IX_EXCEPTION	0	; Return value to raise an exception
#define SA_CONSUME_NUM	31	; Ignore StrongARM packets 30 of 31 times
#define SEQNUM_IGNORE	31	; StrongARM fastport sequence num

/* Register declarations (as required for Intel dispatch loop macros)	*/
.local 	dl_reg1 dl_reg2 dl_reg3 dl_reg4 dl_buffer_handle dl_next_block

/* Include files for Intel dispatch loop macros */
#include "DispatchLoop_h.uc"
#include "DispatchLoopImportVars.h"
#include "EthernetIngress.uc"
#include "wwbump_import.h"

/* Include the packet processing macro defined previously */
#include "WWBump.uc"

/* Microblock initialization */
DL_Init[]
EthernetIngress_Init[]
WWBumpInit[]

/* Dispatch loop that runs forever */
.while(1)

Top_Of_Loop#:	/* Top of dispatch loop (for equivalent of C continue)	*/

    /* Test for a frame from the StrongARM */
    DL_SASource[ ]				; Get frame from SA
    alu[--, dl_buffer_handle, -, IX_BUFFER_NULL]; If no frame, go test
    br=0[Test_Ingress#], guess_branch		;  for ingress frame
    br[Send_MB#]				; If frame, go send it

Test_Ingress#: /* Test for an Ethernet frame */

    EthernetIngress[ ]				; Get an Ethernet frame
    alu[--, dl_buffer_handle, -, IX_BUFFER_NULL]; If no frame, go back
    br=0[Top_Of_Loop#]				;  to start of loop

    /* Check if ingress frame valid and drop if not */
    br!=byte[dl_next_block, 0, 1, Drop_Packet#]

    /* Invoke WWBump macro to set output port and classify the frame	*/
    WWBump[]

    /* Use return value from WWBump to dispose of frame:		*/
    /*	  if exception, jump to code that sends to StrongARM		*/
    /*	  else jump to code that sends to egress			*/

    alu[ --, dl_next_block, -, IX_EXCEPTION]	; Return code is exception
    br=0[Send_SA#]				;  so send to StrongARM

    br[Send_MB#]				; Otherwise, send to next
						;  microblock

Send_SA#:
    /* Send the frame to the core component on the StrongARM as an	*/
    /* exception. Note that tag and exception code are assigned by	*/
    /* the microblock WWBump.						*/
    DL_SASink[ ]
    .continue					; Continue dispatch loop

Send_MB#:
    /* Send the frame to the next microblock (egress).  Note that the	*/
    /* output port (field oface hidden in the internal structure) has	*/
    /* been assigned by microblock WWBump.				*/
    DL_MESink[ ]
    nop
    .continue

Drop_Packet#:
	/* Drop the frame and start over getting a new frame */
	DL_Drop[ ]

.endw

nop			; Although the purpose of these no-ops is
nop			; undocumented, Intel examples include them.
nop
.endlocal
