/* WWBump.uc - microcode to process a packet */

#define	ETH_IP		0x800		; Ethernet type for IP 
#define IPT_TCP		6		; IP type for TCP
#define TCP_WWW		80		; Dest. port for WWW

#macro WWBumpInit[]
	/* empty because no initialization is needed */
#endm

#macro WWBump[]
    xbuf_alloc[$$hdr,6]		; Allocate 6 SDRAM registers

    /* Reserve a register (ifn) and compute the output port for the	*/
    /* frame; a frame that arrives on port 0 will go out port 1, and	*/
    /* vice versa							*/

    .local ifn
	DL_GetInputPort[ifn]		; Copy input port number to ifn
	alu [ ifn, ifn, XOR, 1 ]	; XOR with 1 to reverse number
	DL_SetOutputPort[ifn]		; Set output port for egress
    .endlocal

    /* Read first 24 bytes of frame header from SDRAM */

    .local base off
	Buf_GetData[base, dl_buffer_handle] ; Get the base SDRAM address
        DL_GetBufferOffset[off]		; Get packet offset in bytes
	alu_shf[off, --, B, off, >>3]	; Convert to Quad-words
	sdram[read, $$hdr0, base, off, 3], ctx_swap ; Read 3 Quadwords
						    ;  (six registers)
    .endlocal

    /* Classify the packet.  If any test fails, branch to NotWeb#	*/

    /* Verify frame type is IP (1st two bytes of the 4th longword)	*/

    .local etype
	immed[etype, ETH_IP]
	alu_shf[ --, etype, -, $$hdr3, >>16]	; 2nd operand is shifted
	br!=0[NotWeb#]
    .endlocal

    /* Verify IP type is TCP (last byte of the 6th longword)		*/

    br!=byte[$$hdr5, 0, IPT_TCP, NotWeb#]

    /* Verify destination port is web (offset depends on IP header size	*/

    .local base boff dpoff dport

	/* Get length of IP header (3rd byte of 4th longword), and	*/
	/* convert to bytes by shifting by six bits instead of eight	*/

	ld_field_w_clr[dpoff, 0001, $$hdr3, >>6] ; Extract header length

	/* Mask off bits above and below the IP length			*/

	.local mask
            immed[mask, 0x3c]		; Mask out upper and lower 2 bits
            alu [ dpoff, dpoff, AND, mask ]
	.endlocal

	/* Register dpoff contains the IP header length in bytes.  Add	*/
	/* Ethernet header length (14) and offset of the destination	*/
	/* port (2) to obtain offset from the beginning of the packet	*/
	/* of the destination port.   Add to SDRAM address of buffer,	*/
	/* and convert to quad-word offset by dividing by 8 (shift 3).	*/

	alu[dpoff, dpoff, +, 16]		; Add Ether+TCP offsets
	Buf_GetData[base, dl_buffer_handle]	; Get buffer base address
	DL_GetBufferOffset[boff]		; Get data offset in buf.
	alu[boff, boff, +, dpoff]		; Compute byte address
	alu_shf[boff, --, B, boff, >>3]		; Convert to Q-Word addr.
	sdram[read, $$hdr0, base, boff, 1], ctx_swap	; Read 8 bytes

	/* Use lower three bits of the byte offset to determine which	*/
	/* byte the destination port will be in.  If value >= 4, dest.	*/
	/* port is in the 2nd longword; otherwise it's in the first.	*/

	alu[ dpoff, dpoff, AND, 0x7 ]		; Get lowest three bits
	alu[ --, dpoff, -, 4]			; Test and conditional
	br>=0[SecondWord#]			;   branch if value >=4

FirstWord#:	/* Load upper two bytes of register $$hdr0 */
	ld_field_w_clr[dport, 0011, $$hdr0, >>16] ; Shift before mask
	br[GotDstPort#]				; Check port number

SecondWord#:	/* Load lower two bytes of register $$hdr1 */

	ld_field_w_clr[dport, 0011, $$hdr1, >>16] ; Shift before mask

GotDstPort#:	/* Verify destination port is 80 */

	.local wprt
	    immed[wprt, TCP_WWW]		; Load 80 in reg. wprt
	    alu[--, dport, -, wprt]		; Compare dport to wprt
	    br!=0[NotWeb#]			;  and branch if not equal
	.endlocal
    .endlocal

IsWeb#:		/* Found a web packet, so send to the StrongARM */

    /* Set exception code to zero (we must set this) 		*/
    .local exc					; Declare register exc
	immed[exc, 0]				; Place zero in exc and
	DL_SetExceptionCode[exc]		;  set exception code
    .endlocal

    /* Set tag core component's tag (required by Intel macros) */
    .local ace_tag				; Declare register ace_tag
	immed32[ace_tag, WWBUMP_TAG]		; Place wwbump tag in reg.
	DL_SetAceTag[ace_tag]			;  and set tag
    .endlocal

    /* Set register dl_next_block to IX_EXCEPTION to cause dispatch	*/
    /*   to pass packet to StrongARM as an exception			*/
    immed[dl_next_block, IX_EXCEPTION]		; Store return value
    br[Finish#]					; Done, so branch to end

NotWeb#:	/* Found a non-web packet, so forward to next microblock*/
    immed32[dl_next_block, 1]			; Set return code to 1

Finish#:	/* Packet processing is complete, so clean up		*/
xbuf_free[$$hdr]				; Release xfer registers
#endm
