/* action.c -- Core component of wwbump that handles exceptions */

#include <wwbump.h>
#include <stdlib.h>
#include <wwbcc.h>

ix_error exception(void *ctx, ix_ring r, ix_buffer b)
{
    struct wwbump *wwb = (struct wwbump *) ctx;    /* ctx is the ACE */
    ix_error e;
    unsigned char c;
    (void) r;	/* Note:  not used in our example code */


    /* Get the exception code: Note: Intel code requires this step */
    e = RmGetExceptionCode(wwb->tag, &c);
    if ( e ) {
        fprintf(stderr, "%s:  Error getting exception code", wwb->name);
        ix_error_dump(stderr, e);
        ix_buffer_del(b);
        return e;
    }

    Webcnt++;	/* Count the packet as a web packet */

    /* Send the packet back to wwbump microblock */
    e = RmSendPacket(wwb->tag, b);
    if ( e ) {	/* If error occurred, report the error */
        ix_error_dump(stderr, e);
        ix_buffer_del(b);
        return e;
    }

    return 0;
}

/* A core component must define an ix_action_default function that is	*/
/* invoked if a frame arrives from the core component of another ACE.	*/
/* Because wwbump does not expect such frames, the version of the	*/
/* default function used with wwmbump simply deletes any packet that	*/
/* it receives via this interface.                                      */

int ix_action_default(ix_ace * a, ix_buffer b)
{
    (void) a;			/* This line prevents a compiler warning*/
    ix_buffer_del(b);		/* Delete the frame			*/
    return RULE_DONE;		/* This step required			*/
}
