/* wwbcc.c -- wwbump crosscall functions */

#include <stdlib.h>
#include <string.h>
#include <wwbump.h>
#include <wwbcc.h>
#include "wwbump_sk_c.h"
#include "wwbump_cc_c.h"


long Webcnt;		/* Stores the count of web packets */

/* Initialization function for the crosscall */

ix_error cc_init(struct wwbump *wwb)
{
    CC_VMT_wwbump *vmt = 0;
    ix_cap *capp;
    ix_error e;

    /* Initialize an ix_base_t structure to 0 */
    memset(&wwb->ccbase, 0, sizeof(wwb->ccbase));

    /* Get the OMS communications access point (CAP) of the ACE */
    ix_ace_to_cap(&wwb->ace, &capp);

    /* Invoke the crosscall initialization function and check for error */
    e = sk_wwbump_init(&wwb->ccbase, capp);
    if (e)
        return ix_error_new(0,0,e,"Error in sk_wwbump_init()\n");


    /* Retarget incoming crosscalls to our getcnt function */

    /* Get a pointer to the CrossCall Virtual Method Table */
    e = getCCVMT_wwbump(&wwb->ccbase, &vmt);
    if (e) 
    {
        sk_wwbump_fini(&wwb->ccbase);
        return ix_error_new(0,0,e,"Error in getCCVMT_wwbump()\n");
    }

    /* Retarget function pointer in the table to getcnt */
    vmt->_pCC_wwbump_getcnt = getcnt;

    /* Set initial count of web packets to zero */
    Webcnt = 0;

    return 0;
}

/* Cross call termination function */
ix_error cc_fini(struct wwbump *wwb)
{
    ix_error e;
    /* Finalize crosscall and check for error */
    e = sk_wwbump_fini(&wwb->ccbase);
    if ( e )
        return ix_error_new(0,0,e,"Error in sk_wwbump_fini()\n");

    return 0;	/* If no error, indicate sucessful return */
}

/* Function that is invoked each time a crosscall occurs */
ix_error getcnt(ix_base_t* bp, long* rv)
{
    (void)bp;	/* Reference unused arg to prevent compiler warnings */

    /* Actual work: copy the web count into the return value */
    *rv = Webcnt;

    /* Return 0 for success */
    return 0;
}
