/* wwbump.h -- global constants and declarations for wwbump */

#ifndef	__WWBUMP_H
#define	__WWBUMP_H

#include <ix/asl.h>
#include <ix/microace/rm.h>
#include <ix/asl/ixbasecc.h>
#include <wwbump_import.h>


typedef struct wwbump wwbump;
struct wwbump
{
	ix_ace  ace;	    /* Mandatory handle for all ACEs		*/

	char    name[128];  /* Name of this ACE given in ixsys.config	*/
	int     tag;	    /* ID assigned by RM for SA-to-ME communic.	*/
	int     ue;	    /* Bitmask of MEs this MicroACE runs on	*/
	char    bname[128]; /* Block name (need .import_var $bname_TAG)	*/
	ix_base_t ccbase;   /* Handle for cross call service		*/
};


/* Exception handler prototype */
int     exception(void *ctx, ix_ring r, ix_buffer b);


#endif /* __WWBUMP_H */
