/* -*- C -*- $Id$ */

/******  Code generated by the IX IDL Compiler *******
 * The IX IDL compiler has been developed by Intel Corp. in order
 * to work in conjunction with OMS communication infrastucture and
 * is based on freely available TAO IDL compiler developed by
 * the Center for Distributed Object Computing at
 * Washington University, St. Louis.
 *
 * Information about TAO IDL compiler is available at:
 *                 http://www.cs.wustl.edu/~schmidt/TAO.html
 */

#include <stdlib.h>

#include "Async_stub_c.h"
#include "Async_cb_c.h"


/**=================================================
 * Start stub definition of interface Async
 *================================================*/


/* Declare the interface name for Async interface */
const char Async_intName[] = "Async";

/* Define the local operation names for CC_VMT_Async interface */

/* Define the name for Async::send_command operation */
const char Async_send_command_opName[] = "Async_send_command";


/**=================================================
 * Stub initializer for interface Async
 *================================================*/
ix_error stub_Async_init(ix_base_t * basep, ix_cap * capp)
{
	static const char localFunctionName[] = "stub_Async_init";
	/* static const char* localInterfaceName = Async_intName; */

	ix_error err = 0;
	VMT_CrossCallEntry aVMTCCEntry = { 0, 0, 0 };
	VMT_CrossCallEntry *pVMTCCEntry;
	VMT_CrossCallRefEntry *pVMTCCREntry;

	if (isIDLTokenInitialized(basep) != 0) {
		err = ix_error_new(0, 0, err,
				   "%s - Token is already initialized!",
				   localFunctionName);

		goto err_label1;
	}
	else {
		memset(basep, 0, sizeof(ix_base_t));
	};

	basep->m_pCap = capp;
	basep->connected = 0;
	basep->connecterror = 0;
	basep->ns = 0;
	basep->ccname = 0;
	basep->user_connect_cb = 0;
	basep->cb_ctx = 0;
	basep->connectmutex = 0;

	if (sizeof(basep->m_pCommDesc.guid) <= strlen(Async_intName)) {
		strncpy(basep->m_pCommDesc.guid, Async_intName,
			sizeof(basep->m_pCommDesc.guid) - 1);
		printf("Warning!\n\tThe GUID size is larger than the allocated space for the GUID\n\tin the communication descriptor structure!\n\tThe GUID has been trucated to %d characters!\n", sizeof(basep->m_pCommDesc.guid) - 1);
	}
	else
		strcpy(basep->m_pCommDesc.guid, Async_intName);

	/* crosscall table initialization */
	basep->_vVMTCrossCallSize =
		sizeof(CC_VMT_Async) / sizeof(idl_ixa_c_crossCall_fptr);
	pVMTCCEntry =
		(VMT_CrossCallEntry *) malloc(basep->_vVMTCrossCallSize *
					      sizeof(VMT_CrossCallEntry));
	if (pVMTCCEntry == 0) {
		err = ix_error_new(0, 0, err,
				   "%s - Crosscall VMT table allocation failed!",
				   localFunctionName);

		goto err_label1;
	};
	pVMTCCREntry =
		(VMT_CrossCallRefEntry *) malloc(basep->_vVMTCrossCallSize *
						 sizeof
						 (VMT_CrossCallRefEntry));
	if (pVMTCCREntry == 0) {
		err = ix_error_new(0, 0, err,
				   "%s - Crosscall reference VMT table allocation failed!",
				   localFunctionName);

		goto err_label1;
	};

	/* Intialize the crosscall VMT table entries */

	basep->_pVMTCrossCallRefTable = pVMTCCREntry;
	basep->_pVMTCrossCallTable = pVMTCCEntry;

	pVMTCCEntry->_vName = Async_send_command_opName;
	pVMTCCEntry++;

	idl_ixa_c_qsort(basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize,
			sizeof(VMT_CrossCallEntry),
			cross_call_entry_predicate);


	/* Intialize the crosscall reference table entries */

	aVMTCCEntry._vName = Async_send_command_opName;
	pVMTCCEntry =
		(VMT_CrossCallEntry *) idl_ixa_c_bsearch(&aVMTCCEntry,
							 basep->
							 _pVMTCrossCallTable,
							 basep->
							 _vVMTCrossCallSize,
							 sizeof
							 (VMT_CrossCallEntry),
							 cross_call_entry_predicate);
	pVMTCCREntry->_pCrossCallRefFunc =
		(idl_ixa_c_crossCallRef_fptr) stub_Async_send_command;
	pVMTCCREntry->_vIndex = pVMTCCEntry - basep->_pVMTCrossCallTable;
	pVMTCCREntry++;

	idl_ixa_c_qsort(basep->_pVMTCrossCallRefTable,
			basep->_vVMTCrossCallSize,
			sizeof(VMT_CrossCallRefEntry),
			cross_call_ref_entry_predicate);


	basep->_vTokenType = IDL_IXA_C_CLIENT;
	basep->_pInterfaceName = Async_intName;
	basep->_vInitialized = 1;
	basep->_vInitExtraCheck = isIDLTokenInitialized;

  /**=================================================
   * TO DO: Add your code here!!!
   *================================================*/

      err_label1:
	if (basep->_vInitialized == 0) {
		basep->_vTokenType = IDL_IXA_C_NONE;

		if (basep->_pVMTCrossCallRefTable != 0)
			free(basep->_pVMTCrossCallRefTable);
		if (basep->_pVMTCrossCallTable != 0)
			free(basep->_pVMTCrossCallTable);
		basep->_vVMTCrossCallSize = 0;

	};
	return err;
}

/**=================================================
 * Stub finalizer for interface Async
 *================================================*/
ix_error stub_Async_fini(ix_base_t * basep)
{
	static const char localFunctionName[] = "stub_Async_fini";
	static const char *localInterfaceName = Async_intName;

	ix_error err = 0;

	if (isIDLTokenInitialized(basep) == 0) {
		err = ix_error_new(0, 0, err,
				   "%s - Token is not initialized!",
				   localFunctionName);

		goto err_label1;
	};
	if (basep->_vTokenType != IDL_IXA_C_CLIENT) {
		err = ix_error_new(0, 0, err,
				   "%s - Token is not of CLIENT type!",
				   localFunctionName);

		goto err_label1;
	};
	if (basep->_pInterfaceName != localInterfaceName) {
		err = ix_error_new(0, 0, err,
				   "%s - Token has not been intialized for this interface type!",
				   localFunctionName);

		goto err_label1;
	};
  /**=================================================
   * TO DO: Add your code here!!!
   *================================================*/

	basep->_vTokenType = IDL_IXA_C_NONE;

	free(basep->_pVMTCrossCallRefTable);
	free(basep->_pVMTCrossCallTable);
	basep->_vVMTCrossCallSize = 0;
	memset(basep, 0, sizeof(ix_base_t));

      err_label1:
	return err;
}

/**=================================================
 * Define the interface operations
 *================================================*/
ix_error stub_Async_send_command(ix_base_t * basep, const char *command)
{
	static const char localFunctionName[] = "stub_Async_send_command";
	static const char *localOperationName = Async_send_command_opName;

	ix_error err = 0;
	ix_sds  aSds = 0;
	int     opIndex;
	ix_timespan aTimeout = 0;

	opIndex =
		getIDLOperationIndex(basep,
				     (idl_ixa_c_crossCallRef_fptr)
				     stub_Async_send_command);
	if (opIndex < 0) {
		return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_RANGE, 0,
				    IX_ERROR_LEAD_FMT
				    ("method not found in interface")
				    "\t%s - unable to locate method %s in interface\n"
				    "\tgetIDLOperationIndex returns %d\n",
				    IX_ERROR_LEAD_ARGS, localFunctionName,
				    localOperationName, opIndex);

	};


#ifdef _IDL_OUTPUT_DEBUG
	printf("%s - Operation %s called!\n", localFunctionName,
	       localOperationName);
	printf("\t%s - Operation index is : %d\n", localFunctionName,
	       opIndex);
#endif /* _IDL_OUTPUT_DEBUG */

  /**=================================================
   * Create an SDS 
   *================================================*/
	err = ix_sds_new(&aSds);
	if (err)
		return ix_error_new(0, 0, err,
				    "%s - ix_sds_new failed!",
				    localFunctionName);

  /**=================================================
   * Store two integers at the beginning of SDS 
   *================================================*/
	err = ix_sds_r_int(aSds, 0);
	if (err) {
		err = ix_error_new(0, 0, err,
				   "%s - SDS header marshaling failed!",
				   localFunctionName);
		goto err_label1;
	};
	err = ix_sds_r_int(aSds, 0);
	if (err) {
		err = ix_error_new(0, 0, err,
				   "%s - SDS header marshaling failed!",
				   localFunctionName);
		goto err_label1;
	};

  /**=================================================
   * Marshal and store operation ID 
   *================================================*/
	err = ix_sds_r_int(aSds, opIndex);
	if (err) {
		err = ix_error_new(0, 0, err,
				   "%s - SDS operation ID marshaling failed!",
				   localFunctionName);
		goto err_label1;
	};

  /**=================================================
   * Marshal in and inout arguments 
   *================================================*/
	err = ix_sds_r_string(aSds, command);
	if (err) {
		err = ix_error_new(0, 0, err,
				   "%s - argument marshaling failed for command!",
				   localFunctionName);
		goto err_label1;
	};

	err = ix_dxProcMessage(basep->m_pCap,	/* Pointer to a ix_cap structure */
			       basep->m_pCommDesc,	/* Communication descriptor */
			       &aSds,	/* Message to send */
			       OMS_CT_ONEWAY,	/* Call type, tells Muxer how to handle call. */
			       NULL,	/* Callback not used for one way */
			       aTimeout);
	if (err) {
		err = ix_error_new(0, 0, err,
				   "%s - ix_dxProcMessage() failed!",
				   localFunctionName);
		goto err_label1;
	};

	return err;

      err_label1:
	{
    /**=================================================
     * Delete the created sds in the case of error
     *================================================*/
		if (aSds) {
			ix_error err1 = ix_sds_del(aSds);
			if (err1)
				err = ix_error_new(0, 0, err1,
						   "%s - ix_sds_del failed!",
						   localFunctionName);
		};
	};
	return err;
}



/**=================================================
 * End stub definition of interface Async
 *================================================*/
