#ifndef __gencc_h
#define __gencc_h
#include <ix/asl.h>
#include <ix/ossl.h>
#include <ix/asl/ixbasecc.h>
#include <stdio.h>

#define CK(A) do { ix_error e; if ( (e = (A)) ) { \
                   ix_error_dump(stderr, e); return -1; } } while (0)

struct gencc
{
	ix_base_t	base;
	ix_task		task;
	ix_cap		*capp;
	ix_mutex	mutex;
	ix_cond		cond;
	ix_ossl_thread_t tid;
	int		type;
	int		ans;
	void		*ctx;
};

#define ONEWAY		0
#define TWOWAY		1
#define DEFERRED	2
#define OWNCAP		4

int gencc_init(struct gencc *gp, int type, char *name,
	       ix_error(*init) (ix_base_t * base, ix_cap * capp),
	       ix_cap * capp, ix_oms_connect_cb * cb);

ix_error gencc_threadrun(void *aux, void **rv);

int gencc_fini(struct gencc *gp, ix_error(*fini) (ix_base_t * base),
	       ix_oms_connect_cb * cb);


ix_error gencc_disconnect_cb(ix_error e, void *ctx, int iscon);


#endif /* __gencc_h */
