/* Christopher Telfer */
#ifndef __npapi_h
#define __npapi_h

#include <ix/asl.h>

typedef void (*timer_func) (void *arg);
#define NTIMEEVENTS	20

struct fbuffer
{
	int     len;
	int     ifnum;
	int     ofnum;
	char    frame[1];
};

int     on_startup(void);
void    on_shutdown(void);
void    recv_frame(struct fbuffer *fb);
int     send_frame(struct fbuffer *fb);
int     delayed_call(timer_func f, void *arg, int d);
int     periodic_call(timer_func f, void *arg, int p);
void    cancel_call(int id);
void    console_command(const char *cmd);
struct fbuffer *new_fbuf(int len);


/* Auxiliary functions to convert frame buffers to internal IX Buffers */
struct fbuffer *ixb2fb(ix_buffer ixb);
ix_buffer fb2ixb(struct fbuffer *fb);

#endif /* __npapi_h */
