/* -*- C -*- $Id$ */

/******  Code generated by the IX IDL Compiler *******
 * The IX IDL compiler has been developed by Intel Corp. in order
 * to work in conjunction with OMS communication infrastucture and
 * is based on freely available TAO IDL compiler developed by
 * the Center for Distributed Object Computing at
 * Washington University, St. Louis.
 *
 * Information about TAO IDL compiler is available at:
 *                 http://www.cs.wustl.edu/~schmidt/TAO.html
 */

#include <stdlib.h>

#include "Async_sk_c.h"
#include "Async_cc_c.h"


/**=================================================
 * Start definitions for interface Async
 *================================================*/


/* Server initialization function for Async interface */
ix_error sk_Async_init(ix_base_t * basep, ix_cap * capp)
{
	static const char localFunctionName[] = "sk_Async_init";
	/* static const char* localInterfaceName = Async_intName; */

	VMT_CrossCallEntry *pVMTCCEntry;
	CC_VMT_Async *pCCVMT;
	ix_error err = 0;

	if (isIDLTokenInitialized(basep) != 0) {
		err = ix_error_new(0, 0, err,
				   "%s - Token is already initialized!",
				   localFunctionName);

		goto err_label1;
	}
	else {
		memset(basep, 0, sizeof(ix_base_t));
	};

	pCCVMT = (CC_VMT_Async *) malloc(sizeof(CC_VMT_Async));
	if (pCCVMT == 0) {
		err = ix_error_new(0, 0, err,
				   "%s - Crosscall VMT allocation failed!",
				   localFunctionName);

		goto err_label1;
	};

	/* Intialize the crosscall VMT */

	basep->_pVMTCrossCall = pCCVMT;

	pCCVMT->_pCC_Async_send_command = Async_send_command;

	/* crosscall table initialization */
	basep->_vVMTCrossCallSize =
		sizeof(CC_VMT_Async) / sizeof(idl_ixa_c_crossCall_fptr);
	pVMTCCEntry =
		(VMT_CrossCallEntry *) malloc(basep->_vVMTCrossCallSize *
					      sizeof(VMT_CrossCallEntry));
	if (pVMTCCEntry == 0) {
		err = ix_error_new(0, 0, err,
				   "%s - Crosscall VMT table allocation failed!",
				   localFunctionName);

		goto err_label1;
	};

	/* Intialize the crosscall VMT table entries */

	basep->_pVMTCrossCallTable = pVMTCCEntry;

	pVMTCCEntry->_vName = Async_send_command_opName;
	pVMTCCEntry->_pCrossCallFuncPtr =
		(idl_ixa_c_crossCall_fptr *) & pCCVMT->
		_pCC_Async_send_command;
	pVMTCCEntry->_pUpcallInvokeFunc =
		(idl_ixa_c_upcallInvoke_fptr) invoke_Async_send_command;
	pVMTCCEntry++;

	idl_ixa_c_qsort(basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize,
			sizeof(VMT_CrossCallEntry),
			cross_call_entry_predicate);


	basep->m_pCap = capp;


  /**=================================================
   * Register the dispatch function 
   *================================================*/
	err = ix_dx_reg_dispatch(capp,	/* Pointer to a ix_cap structure */
				 Async_intName,	/* GUID of the interface */
				 idl_ixa_c_dispatch,	/* Dispatch function */
				 (void *) basep);	/* A ix_base_t* passed as a cookie */

	if (err) {
		err = ix_error_new(0, 0, err,
				   "%s - ix_dx_reg_dispatchfailed!",
				   localFunctionName);

		goto err_label1;
	};

	basep->_vTokenType = IDL_IXA_C_SERVER;
	basep->_pInterfaceName = Async_intName;
	basep->_vInitialized = 1;
	basep->_vInitExtraCheck = isIDLTokenInitialized;

  /**=================================================
   * TO DO: Add your code here!!!
   *================================================*/

      err_label1:
	if (basep->_vInitialized == 0) {
		basep->_vTokenType = IDL_IXA_C_NONE;

		if (basep->_pVMTCrossCallTable != 0)
			free(basep->_pVMTCrossCallTable);
		basep->_vVMTCrossCallSize = 0;
		if (basep->_pVMTCrossCall != 0)
			free(basep->_pVMTCrossCall);

	};
	return err;
}

/* Server finalization function for Async interface */
ix_error sk_Async_fini(ix_base_t * basep)
{
	static const char localFunctionName[] = "sk_Async_fini";
	static const char *localInterfaceName = Async_intName;

	ix_error err = 0;

	if (isIDLTokenInitialized(basep) == 0) {
		err = ix_error_new(0, 0, err,
				   "%s - Token is not initialized!",
				   localFunctionName);

		goto err_label1;
	};
	if (basep->_vTokenType != IDL_IXA_C_SERVER) {
		err = ix_error_new(0, 0, err,
				   "%s - Token is not of SERVER type!",
				   localFunctionName);

		goto err_label1;
	};
	if (basep->_pInterfaceName != localInterfaceName) {
		err = ix_error_new(0, 0, err,
				   "%s - Token has not been intialized for this interface type!",
				   localFunctionName);

		goto err_label1;
	};
  /**=================================================
   * TO DO: Add your code here!!!
   *================================================*/

  /**=================================================
   * Unregister the dispatch function 
   *================================================*/
	/*
	   err = ix_dx_unreg_dispatch(Async_intName);
	   if(err)
	   {
	   err = ix_error_new(0, 0, err, 
	   "%s - Unregister function failed!", localFunctionName);

	   goto err_label1;
	   };
	 */

	basep->_vTokenType = IDL_IXA_C_NONE;

	free(basep->_pVMTCrossCallTable);
	basep->_vVMTCrossCallSize = 0;
	free(basep->_pVMTCrossCall);
	memset(basep, 0, sizeof(ix_base_t));

      err_label1:
	return err;
}

/* Accessor function for crosscall VMT */
extern ix_error getCCVMT_Async(const ix_base_t * basep,
			       CC_VMT_Async ** pInterfaceCCVMT)
{
	static const char localFunctionName[] = "CB_VMT_Async";
	static const char *localInterfaceName = Async_intName;

	ix_error err = 0;

	*pInterfaceCCVMT = 0;
	if (isIDLTokenInitialized(basep) == 0) {
		err = ix_error_new(0, 0, err,
				   "%s - Token is not initialized!",
				   localFunctionName);

		goto err_label1;
	};
	if (basep->_vTokenType != IDL_IXA_C_SERVER) {
		err = ix_error_new(0, 0, err,
				   "%s - Token is not of SERVER type!",
				   localFunctionName);

		goto err_label1;
	};
	if (basep->_pInterfaceName != localInterfaceName) {
		err = ix_error_new(0, 0, err,
				   "%s - Token has not been intialized for this interface type!",
				   localFunctionName);

		goto err_label1;
	};

	*pInterfaceCCVMT = (CC_VMT_Async *) basep->_pVMTCrossCall;

      err_label1:
	return err;
}


/**=================================================
 * Start invoke functions definitions for interface Async
 *================================================*/


/* Definition of invoke function for Async::send_command operation */
extern ix_error invoke_Async_send_command(ix_base_t * basep, ix_sds aSds,
					  idl_ixa_c_crossCall_fptr pFunc)
{
	static const char localFunctionName[] = "invoke_Async_send_command";
	static const char *localOperationName = Async_send_command_opName;

	ix_error err = 0;
	(void) aSds;

#ifdef _IDL_OUTPUT_DEBUG
	printf("%s - Crosscall for operation %s invoked!\n",
	       localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */

	if (pFunc == 0) {
		err = ix_error_new(0, 0, err,
				   "%s - Pure virtual crosscall function for %s operation!",
				   localFunctionName, localOperationName);

		goto err_label3;
	};
	{
		char   *command;

    /**=================================================
     * Intialize variables 
     *================================================*/
		command = 0;

    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
		err = ix_sds_p_string(aSds, &command);
		if (err) {
			err = ix_error_new(0, 0, err,
					   "%s - argument demarshaling failed for command!",
					   localFunctionName);
			goto err_label1;
		};

    /**=================================================
     * Make the upcall 
     *================================================*/
		err = ((Async_send_command_fptr) pFunc) (basep, command);
		if (err) {
			err = ix_error_new(0, 0, err,
					   "%s - crosscall for Async_send_command operation failed!",
					   localFunctionName);
			goto err_label1;
		};

	      err_label1:

    /**=================================================
     * Finalize variables 
     *================================================*/

		if (command != 0) {
			free(command);
			command = 0;
		};
		(void) localFunctionName;
		(void) localOperationName;

	};
      err_label3:
	return err;
}


/**=================================================
 * End invoke functions definitions for interface Async
 *================================================*/



/**=================================================
 * End definitions for interface Async
 *================================================*/
