#include <AsyncAPI.h>
#include <npapi.h>
#include <stdlib.h>



int ix_action_default(ix_ace * a, ix_buffer b)
{
	struct fbuffer *f;

	(void) a;

	f = ixb2fb(b);

	ix_buffer_del(b);

	if (f)
		recv_frame(f);

	return RULE_DONE;
}




/*
 Intel Note:

 This function is called when you receive exception packets from the
 microengine
 
 THIS FUNCTION NEEDS TO RETURN an ix_error and not RULE_DONE. 

*/

int ExceptionHandler(void *ctx, ix_ring r, ix_buffer b)
{
	AsyncAPIAce *a = (AsyncAPIAce *) ctx;
	ix_error e;
	unsigned char c;
	struct fbuffer *f;

	(void) r;


	/* Now get the exception code : THIS MUST MUST MUST BE DONE */
	if ((e = RmGetExceptionCode(a->tag, &c))) {
		fprintf(stderr, "%s:  Error getting exception code",
			a->name);
		ix_error_dump(stderr, e);
		ix_buffer_del(b);
		return e;
	}

	f = ixb2fb(b);

	if ((e = ix_buffer_del(b))) {
		free(f);	/* OK if its NULL */
		return e;
	}

	if (!f) {
		return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_MEMORY_ERRORS, 0,
				    "Error mallocing fbuffer in Exception handler\n");
	}

	recv_frame(f);

	return 0;
}





void DumpPacket(ix_buffer b)
{
	ix_error e;
	size_t  s;
	int     i, type, ifn, ift, rxs, len;
	ix_time rxt;
	char   *p;


	fprintf(stderr, "Buffer handle is %x\n", b);

	if ((e = ix_buffer_get_size(b, &s)))
		goto error;

	if ((e = ix_buffer_get_type(b, &type)))
		goto error;

	if ((e = ix_buffer_get_ifnum(b, &ifn)))
		goto error;

	if ((e = ix_buffer_get_iftype(b, &ift)))
		goto error;

	if ((e = ix_buffer_get_rxstat(b, &rxs)))
		goto error;

	if ((e = ix_buffer_get_rxtime(b, &rxt)))
		goto error;

	if ((e = ix_buffer_get_data(b, 0, 0, &p, &len)))
		goto error;

	fprintf(stderr,
		"Packet: size %d, type 0x%x, ifnum 0x%x, iftype 0x%x, rxstat"
		" 0x%x\n",
		s, type, ifn, ift, rxs);


	/* Now print the actual bytes */
	for (i = 0; i < len; i++) {
		fprintf(stderr, "%02x ", p[i]);

		if (i % 20 == 19)
			fprintf(stderr, "\n");
	}

	/* Polish up our line feeds */
	if (len % 20 != 0)
		fprintf(stderr, "\n");
	fprintf(stderr, "\n");

	return;


error:
	fprintf(stderr, "AsyncAPIAce->DumpPacket: error getting buffer"
	        " attribute\n");
	ix_error_dump(stderr, e);
}
