#include <AsyncAPI.h>
#include <npapi.h>
#include <stdlib.h>
#include <stdio.h>


struct time_event_s
{
	ix_event	event;
	int		period;
	timer_func	f;
	void		*arg;
}
TimeEvents[NTIMEEVENTS];


int     calllater(timer_func f, void *arg, int msec, int isp);

void    init_time_events(void);

void init_time_events(void)
{
	int     i;

	for (i = 0; i < NTIMEEVENTS; ++i)
		TimeEvents[i].period = -1;
}


static ix_error wrappercallback(ix_event * evp)
{
	struct time_event_s *tep = (struct time_event_s *) evp;
	ix_time t1, t2;
	ix_error e;

	if (tep->period < 0)	/* Error.  Cancelled but not fixed. */
		return 0;

	if (tep->period) {

		if ((e = ix_time_curr(&t1)))
			goto fail;

		if ((e = ix_time_add_secs(&t2, &t1, tep->period / 1000)))
			goto fail;

		if ((e =
		     ix_time_add_nsec(&t1, &t2,
				      (tep->period % 1000) * 1000000)))
			goto fail;

		if ((e =
		     ix_event_schedule(Self->base->cap, &tep->event, &t1)))
			goto fail;
	}

	tep->f(tep->arg);

	if (!tep->period) {
		tep->period = -1;
	}

	return 0;

fail:
	tep->period = -1;
	fprintf(stderr, "Error reinitializing periodic timer callback!\n");
	ix_error_dump(stderr, e);
	return e;
}



int calllater(timer_func f, void *arg, int msec, int isp)
{
	struct time_event_s *tep;
	ix_error e;
	ix_time t1, t2;
	int     i;

	for (i = 0; (i < NTIMEEVENTS) && (TimeEvents[i].period >= 0); ++i);

	if (i == NTIMEEVENTS)
		return -1;

	tep = (struct time_event_s *) &TimeEvents[i];

	if ((e = ix_event_init(&tep->event)))
		return -1;

	tep->f = f;
	tep->arg = arg;
	if (isp)
		tep->period = msec;
	else
		tep->period = 0;

	if ((e = ix_time_curr(&t1)))
		goto fail;

	if ((e = ix_time_add_secs(&t2, &t1, msec / 1000)))
		goto fail;

	if ((e = ix_time_add_nsec(&t1, &t2, (msec % 1000) * 1000000)))
		goto fail;

	if ((e = ix_event_call(&tep->event, wrappercallback)))
		goto fail;

	if ((e = ix_event_schedule(Self->base->cap, &tep->event, &t1)))
		goto fail;

	return i;

      fail:
	tep->period = -1;
	return -1;
}



void cancel_call(int id)
{
	if (TimeEvents[id].period >= 0)
		ix_event_cancel(&TimeEvents[id].event);

	TimeEvents[id].period = -1;
}



int delayed_call(timer_func f, void *arg, int d)
{

	return calllater(f, arg, d, 0);
}


int periodic_call(timer_func f, void *arg, int p)
{
	return calllater(f, arg, p, 1);
}
