#include <npapi.h>
#include <stdlib.h>
#include <string.h>

#define offsetof(type, field) ((int)(&(((type *)0)->field)))


struct fbuffer *new_fbuf(int len)
{
	int		t;
	struct fbuffer	*f;

	t = offsetof(struct fbuffer, frame) + len;
	f = malloc(t);
	if (!f) {
		fprintf(stderr,
			"newbuf:  Error allocating buffer!  Malloc failed!\n");
		return 0;
	}

	f->len = len;
	f->ifnum = 0;
	f->ofnum = -1;

	return f;
}



struct fbuffer *ixb2fb(ix_buffer ixb)
{
	int     len, ifn, ofn, off, cl;
	char   *cp;
	ix_error e;
	struct fbuffer *f;

	if ((e = ix_buffer_get_size(ixb, &len)))
		goto fail;

	if ((e = ix_buffer_get_ifnum(ixb, &ifn)))
		goto fail;

	if ((e = ix_buffer_get_ofnum(ixb, &ofn)))
		goto fail;

	f = new_fbuf(len);
	if (!f)
		return 0;

	off = 0;
	while (off < len) {
		if ((e = ix_buffer_get_data(ixb, off, 0, &cp, &cl))) {
			free(f);
			goto fail;
		}

		memmove(f->frame + off, cp, cl);
		off += cl;
	}

	f->ifnum = ifn;
	f->ofnum = ofn;
	f->len = len;

	return f;

      fail:
	ix_error_dump(stderr, e);
	return 0;
}




ix_buffer fb2ixb(struct fbuffer * f)
{
	ix_buffer ixb;
	ix_error e;

	if (!f)
		return 0;

	if ((e = ix_buffer_get(&ixb))) {
		ix_error_dump(stderr, e);
		return 0;
	}

	if ((e = ix_buffer_put_rxstat(ixb, 0)))
		goto fail;

	if ((e = ix_buffer_put_data(ixb, f->frame, f->len)))
		goto fail;

	if ((e = ix_buffer_put_type(ixb, IX_HTYPE_ETHER)))
		goto fail;

	if ((e = ix_buffer_put_ifnum(ixb, f->ifnum)))
		goto fail;

	if ((e = ix_buffer_put_ofnum(ixb, f->ofnum)))
		goto fail;

	return ixb;

      fail:
	ix_error_dump(stderr, e);
	ix_buffer_del(ixb);
	return 0;
}
