#include <gencc.h>

ix_error gencc_threadrun(void *aux, void **rv)
{
	struct gencc *gp = (struct gencc *) aux;
	ix_error e = 0;
	(void) rv;

	ix_error_init(64, 512);
	e = ix_cap_loop(gp->capp);

	if (!e || ix_error_is(e, 0, IX_ERROR_STOP)) {
		return 0;
	}
	else {
		ix_error_dump(stderr, e);
		return e;
	}
}



int gencc_init(struct gencc *gp,
	       int type,
	       char *name,
	       ix_error(*init) (ix_base_t * base, ix_cap * capp),
	       ix_cap * capp, 
	       ix_oms_connect_cb * cb)
{
	if (!gp)
		return -1;

	gp->type = type;
	gp->ans = 0;
	if (!capp) {
		CK(ix_task_init(&gp->task, "gencc_task"));
		CK(ix_task_to_cap(&gp->task, &gp->capp));
	}
	else {
		gp->type |= OWNCAP;
		gp->capp = capp;
	}

	memset(&gp->base, 0, sizeof(gp->base));


	if ((type & DEFERRED) && !(gp->type & OWNCAP)) {
		CK(ix_mutex_new(&gp->mutex, IX_MUTEX_UNLOCKED));
		CK(ix_cond_new(&gp->cond));
	}

	if (!(gp->type & OWNCAP)) {
		CK(ix_ossl_create_thread
		   (&gp->tid, gencc_threadrun, (void *) gp));
	}

	CK((*init)(&gp->base, gp->capp));

	if (gp->type & OWNCAP) {
		CK(ix_oms_cb_connect(&gp->base, name, cb, gp));
	}
	else {
		CK(ix_oms_connect(&gp->base, name));
		CK(ix_oms_wait_connected(&gp->base));
	}

	return 0;
}


int gencc_fini(struct gencc *gp,
	       ix_error(*fini) (ix_base_t * base),
	       ix_oms_connect_cb * cb)
{
	int     full;

	if ((gp->type & DEFERRED) && !(gp->type & OWNCAP) && !gp->ans) {
		CK(ix_cond_wait(gp->cond, gp->mutex));
		CK(ix_mutex_release(gp->mutex));
	}

	if (gp->type & OWNCAP) {
		gp->ctx = fini;
		CK(ix_oms_cb_disconnect(&gp->base, cb, gp));
	}
	else {
		CK(ix_oms_disconnect(&gp->base));
		CK(ix_oms_wait_disconnected(&gp->base));
		CK((*fini)(&gp->base));
		CK(ix_cap_shutdown(gp->capp, &full));
		CK(ix_ossl_wait_for_thread(gp->tid, 0, 0));
		CK(ix_task_fini(&gp->task));
		if (gp->type & DEFERRED) {
			CK(ix_cond_del(gp->cond));
			CK(ix_mutex_del(gp->mutex));
		}
	}

	return 0;
}



ix_error gencc_disconnect_cb(ix_error e, void *ctx, int iscon)
{
	struct gencc *gp = (struct gencc *) ctx;
	ix_error(*fini) (ix_base_t * base) = gp->ctx;

	if (e)
		ix_error_dump(stderr, e);

	CK(fini(&gp->base));
	free(gp);

	return e;
}
