/** INTEL CORPORATION PROPRIETARY INFORMATION
**      This software is supplied under the terms of a license agreement or
**      nondisclosure agreement with Intel Corporation and may not be copied
**      or disclosed except in accordance with the terms of that agreement.
**              Copyright (C) 2000 Intel Corporation. All rights Reserved.
*/

/*********************************************************************/

#include <stdlib.h>
#include <string.h>

/*********************************************************************/

#include <AsyncAPI.h>
#include <npapi.h>
#include "Async_sk_c.h"
#include "Async_cc_c.h"
/*********************************************************************/

AsyncAPIAce *Self;


ix_error Async_Send_Command(ix_base_t * bp, const char *c);
void    init_time_events(void);


ix_error ix_init(int argc, char **argv, ix_ace ** ap)
{
	AsyncAPIAce *aap;
	ix_error e;
	ix_cap *capp;
	CC_VMT_Async *vmt = 0;


	/* Allocate an ace structure */
	if (!(aap = malloc(sizeof(*aap))))
		return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_OOM, 0,
				    "ix_init : couldn't allocate AsyncAPIAce");

	if (!(aap->scb = malloc(sizeof(ix_base_t)))) {
		free(aap);
		return ix_error_new(IX_ERROR_LEVEL_LOCAL, IX_ERROR_OOM, 0,
				    "ix_init : couldn't allocate"
				    " newAce->scbase");
	}


	/* Parse the options */
	aap->ue = atoi(argv[2]);
	strcpy(aap->bname, "ASYNC");


	/* Initialize the ace */
	aap->name[sizeof(aap->name) - 1] = '\0';
	strncpy(aap->name, argv[1], sizeof(aap->name) - 1);
	if ((e = ix_ace_init(aap->base, aap->name))) {
		free(aap);
		return ix_error_new(0, 0, e,
				    "AsyncAPIAce : Error in ix_ace_init()\n");
	}


	/* Initialize the microace portion */
	if ((e = RmInit())) {
		free(aap);
		return ix_error_new(0, 0, e,
				    "AsyncAPIAce : Error in RmInit()\n");
	}


	e = RmRegister(&aap->tag, aap->bname, aap->base, ExceptionHandler, 
	               aap, aap->ue);
	if (e) {
		free(aap);
		return ix_error_new(0, 0, e,
				    "AsyncAPIAce : Error in RmRegister()\n");
	}


	/* Set up the crosscalls */
	memset(aap->scb, 0, sizeof(ix_base_t));
	ix_ace_to_cap(aap->base, &capp);
	e = sk_Async_init(aap->scb, capp);
	if (e) {
		free(aap);
		return ix_error_new(0, 0, e,
				    "AsyncAPIAce : sk_Async_init()\n");
	}


	e = getCCVMT_Async(aap->scb, &vmt);
	if (e) {
		free(aap);
		return ix_error_new(0, 0, e,
				    "AsyncAPIAce : getCCVMT_Async()\n");
	}

	vmt->_pCC_Async_send_command = Async_Send_Command;


	/* initialize timing events */
	init_time_events();


	/* Now call the user specific tasks */
	if (on_startup() < 0) {
		free(aap);
		return ix_error_new(IX_ERROR_LEVEL_LOCAL,
				    IX_ERROR_UNSPECIFIED, 0,
				    "Error in user specific initialization code!\n");
	}


	/* Set the ace pointer */
	*ap = aap->base;
	Self = aap;


	return 0;
}




ix_error ix_fini(int argc, char **argv, ix_ace * ap)
{
	AsyncAPIAce *aap = (AsyncAPIAce *) ap;
	ix_error e;


	/* Call the user-specific termination code */
	on_shutdown();


	/* Finalize Cross Call stuff */
	if ((e = sk_Async_fini(aap->scb)))
		return ix_error_new(0, 0, e,
				    "AsyncAPIAce : Error in sk_Async_fini()\n");


	/* MicroACE makes a call to unregister from the resource Manager */
	if ((e = RmUnRegister(aap->tag)))
		return ix_error_new(0, 0, e,
				    "AsyncAPIAce : Error in RmUnRegister()\n");


	/* Close communications with the resource mgr */
	if ((e = RmTerm()))
		return ix_error_new(0, 0, e,
				    "AsyncAPIAce : Error in RmTerm()\n");


	if ((e = ix_ace_fini(aap->base)))
		return ix_error_new(0, 0, e,
				    "AsyncAPIAce : Error in ix_ace_fini()\n");

	free(aap->scb);
	free(aap);
	Self = 0;

	return 0;
}





ix_error Async_Send_Command(ix_base_t * bp, const char *c)
{
	(void) bp;
	console_command(c);
	return 0;
}
