#include <stdio.h>
#include <stdlib.h>
#include <gencc.h>
#include <Async_stub_c.h>
#include <Async_cb_c.h>


int send_command(char *in, char *c)
{
	struct gencc g;
	ix_error e;

	if (gencc_init(&g, ONEWAY, in, stub_Async_init, 0, 0) < 0)
		return -1;

	CK(stub_Async_send_command(&g.base, c));

	if (gencc_fini(&g, stub_Async_fini, 0) < 0)
		return -1;

	return 0;
}


int main(int argc, char *argv[])
{
	char   *c;
	char   *in;

	if (argc < 2) {
		fprintf(stderr, "Error:  Need a message to send!\n");
		exit(-1);
	}

	if (argc == 4 && strcmp(argv[1], "-i") == 0) {
		in = argv[2];
		c = argv[3];
	}
	else {
		in = "AsyncAPIAce";
		c = argv[1];
	}

	if (send_command(in, c) < 0)
		fprintf(stderr,
			"Unknown error sending command to MicroAce\n");

	return 0;
}
