; Constants that _might_ be necessary for DL_*Sink routines
; The last two are necessary for DL_SASource I believe
#define IX_EXCEPTION  		0
#define SA_CONSUME_NUM     31
#define SEQNUM_IGNORE      31

; Define variables that are global for the dispatch loop
; Look in DispatchLook_h.uc for their usage definitions
.local 	dl_reg1 dl_reg2 dl_reg3 dl_reg4 dl_buffer_handle dl_next_block

#include "DispatchLoop_h.uc"
#include "DispatchLoopImportVars.h"
#include "EthernetIngress.uc"
#include "AsyncAPIImportVars.h"

; Do initialization (most likely both are nops)
; Call Dispatch Loop initialization
DL_Init[]
; Call Ethernet ingress initialization
EthernetIngress_Init[]



; The actual dispatch loop
.while(1)
dl_start#:
	; Get a frame from the StrongARM ring if there is one
	DL_SASource[ ]
	; Compare the buffer handle with NULL
	alu[--, dl_buffer_handle, -, IX_BUFFER_NULL]
	; If we didn't get a frame from the SA (buffer == NULL) 
	; get one from Ethernet
	br=0[Main_Dispatch#], guess_branch
	; If we did get a frame from the StrongARM send it to the next ME
	br[DL_MESink#]

Main_Dispatch#:
	; Get a frame from an Ethernet port.
	EthernetIngress[ ]

	; Compare the buffer with NULL
	alu[--, dl_buffer_handle, -, IX_BUFFER_NULL]
	; If we didn't get a buffer from Ethernet go back to start
	br=0[dl_start#]
	; If the Ethernet Ingress says to drop the packet, go to Drop
	; drop if (next_block != 1)
	br!=byte[dl_next_block, 0, 1, DL_Drop#]

	; Set the next block to be an Exception
	; Not sure if this is necessary for DL_* routines.
	immed[dl_next_block, IX_EXCEPTION]
	; Allocate a register to store the Tag of the ACE to send the frame to
	.local ace_tag
	; Set the register to the TAG of the AsyncAPIAce
	immed[ace_tag, ASYNC_TAG]
	; Set the tag in the dl_reg* variables
	DL_SetAceTag[ace_tag]
	; Get rid of the tag variables
	.endlocal

	; Send the frame to the StrongARM exception ring
	DL_SASink[ ]
	; Go back to the top of the loop
	.continue

DL_MESink#:
	; Send the frame to the next Microblock Group
	DL_MESink[ ]
	; (don't know why this is here, but its Intel style)
	nop
	; Go back to the top of the loop
	.continue

DL_Drop#:
	; Drop the packet and start the loop again
	DL_Drop[ ]

.endw

; Intel style.  Not sure why these are here
nop
nop
nop

; release dl_* variables (never reached)
.endlocal
