#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <npapi.h>


#define MACLEN	6
#define SRCOFF	6
#define DSTOFF	0
#define NUMIF	4
#define TABSIZ	1024
#define HTSIZ	1543

int Done = 0;


struct __btab
{
  char		ea[MACLEN];
  int		iface;
  int		next;
} BTab[TABSIZ];


int HT[HTSIZ];


void fail(char *s)
{
  fprintf(stderr, "%s\n", s);
  exit(-1);
}


void shandle(int sig)
{ 
  Done = 1;
}


unsigned short hash(unsigned char ea[MACLEN], unsigned short mod)
{ 
  unsigned short *sp, s;

  sp = (unsigned short *)ea;
  s = *sp++;
  s ^= *sp++;
  s ^= *sp;

  return s % mod;
}


void inittab()
{ 
int i;

  for ( i = 0 ; i < TABSIZ ; i++ )
  {
    BTab[i].iface = -1;
    BTab[i].next  = -1;
  }
  for ( i = 0 ; i < HTSIZ ; i++ )
    HT[i] = -1;
}


int newentry()
{ 
int i;

  for ( i = 0 ; i < TABSIZ ; ++i ) 
  { 
    if ( BTab[i].iface < 0 )
      return i;
  }

  return random() % TABSIZ;
}


int lookup(char ea[MACLEN])
{ 
int te, i;

  te = hash(ea, HTSIZ);
  for ( i = HT[te] ; (BTab[i].iface >= 0) && memcmp(BTab[i].ea, ea, MACLEN) ; 
	i = BTab[i].next) ; 

  return i;
}


void put(char ea[MACLEN], int ifnum)
{
int te, i;

  if ( (i = lookup(ea)) )
  {
    BTab[i].iface = ifnum;
  }
  else
  {
    i = newentry();
    te = hash(ea, HTSIZ);
    BTab[i].iface = ifnum;
    BTab[i].next  = HT[te];
    memcpy(BTab[i].ea, ea, MACLEN);
    HT[te] = i;
  }
}


int main(int argc, char *argv[])
{ 
char buffer[2048];
char ea[6];
struct fbuffer *f = (struct fbuffer *)buffer;
int rv, i;

  inittab();
  signal(SIGINT, shandle);
  signal(SIGTERM, shandle);

  if ( np_start(0, 0) < 0 )
    fail("Couldn't connect to network processor.");


  while ( !Done )
  {
    next_frame(f);

    memcpy(ea, f->frame + DSTOFF, MACLEN);
    if ( (i = lookup(ea)) >= 0 )	/* If we have the src addr */
    { 
      f->ofnum = i;
      send_frame(f, 0);
    }
    else					/* Broadcast to all others */
    {
      for ( i = 0 ; i < NUMIF ; i++ )
      { 
        if ( i == f->ifnum ) 
	  continue;

        f->ofnum = i; 
        send_frame(f, 0);
      }
    }


    /* Now learn the source address */
    memcpy(ea, f->frame + SRCOFF, MACLEN);

    put(ea, f->ifnum);
  }


  if ( rv < 0 )
    fail("Error getting next frame!");

  np_stop();

  return 0;
}
