#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <npapi.h>
#include <ip.h>
#include <ether.h>
#include <arp.h>
#include <udp.h>
#include <tcp.h>
#include <icmp.h>
#include <setbyteorder.h>
#include <frag.h>

#define DBG	fprintf(stderr, "%s->%d\n", __FILE__, __LINE__);

#define EHLEN	14
#define IPHLEN	20
#define HLEN	(EHLEN + IPHLEN)

#define MTU	128
#define MINFLEN	60

#define offsetof(type, field) ((int)(&(((type *)0)->field)))

int fragsend(struct fbuffer *fb)
{
struct ep eh;
struct ip ip, ip2;
int nfb, off, dlen;
struct fbuffer *nb = 0;
char *dp;

  memcpy(&eh, fb->frame, EHLEN);

  if ( ( eh.ep_type != EPT_IP ) || ( fb->len - EHLEN <= MTU ) )
  {
    send_frame(fb, 0);
    return 0;
  }

  memcpy(&ip, fb->frame + EHLEN, IPHLEN);

  nfb = (MTU - IPHLEN) / 8;
  if ( !(nb = new_fbuf(nfb * 8 + IPHLEN + EHLEN)) )
    return -1;
  nb->ifnum = fb->ifnum; 
  nb->ofnum = fb->ofnum;
  memmove(nb->frame, fb->frame, EHLEN);

  off = ip.ip_fragoff & IP_FRAGOFF;
  dlen = ip.ip_len - IPHLEN;
  dp = fb->frame + HLEN;

#if 0 
fprintf(stderr, "first 8 bytes after iph : %x %x %x %x  %x %x %x %x\n",
        dp[0], dp[1], dp[2], dp[3], dp[4], dp[5], dp[6], dp[7]);
#endif

  /* CHANGE:  Doesn't copy about options */

  while ( off*8 < dlen )
  {
    ip2 = ip;

    /* First copy the data */
    if ( ip2.ip_len <= MTU )
    {
      /* Move the last bit of data */
      memmove(nb->frame + HLEN, dp, ip2.ip_len-IPHLEN);

      ip2.ip_fragoff = off;

      /* Calculate the total frame length */
      if ( ip.ip_len + EHLEN < MINFLEN )
        nb->len = MINFLEN;
      else
	nb->len = ip.ip_len + EHLEN;
    }
    else
    {
      /* Copy data */
      memmove(nb->frame + HLEN, dp, nfb * 8);

      /* create new IP header */
      ip2.ip_len = nfb * 8 + IPHLEN;
      ip2.ip_fragoff = off | IP_MF;

      nb->len = ip2.ip_len + EHLEN;
    }

    ip2.ip_cksum = 0;
    ip2.ip_cksum = cksum(&ip2);
    memmove(nb->frame + EHLEN, &ip2, IPHLEN);

    /* Send out the packet */
    send_frame(nb, 0);

    /* The first of these is inaccurate, and the second will underflow when */
    /* the loop terminates */
    off += nfb;
    dp  += nfb * 8;
    ip.ip_len -= nfb * 8;
  }

  free(nb);
  return 0;
}



/* CHANGE:  assumes 2-byte alignemnt!? */
unsigned short cksum(struct ip *pip)
{
unsigned long sum = 0;
int l, i;
unsigned short *sp;

  sp = (unsigned short *)pip;
  l = IPHLEN / 2;

  for ( i = 0 ; i < l ; i++ )
    sum += *sp++;

  sum = (sum & 0xFFFF) + (sum >> 16);
  sum = (sum & 0xFFFF) + (sum >> 16);

  return (unsigned short)~sum;
}
