#ifndef __CAT_AUX_H
#define __CAT_AUX_H

typedef void *cptr; 

typedef int (*cat_match_func)(cptr, cptr);
typedef int (*cat_compare_func)(cptr v1, cptr v2, cptr aux);
typedef int (*cat_foreach_func)(cptr, cptr); 
typedef void (*cat_free_func)(cptr); 
typedef cptr (*cat_copy_func)(cptr); 

int cat_direct_match(cptr, cptr); 


/* In case the library wants to handle its own memory management specially */
cptr cat_getm(int len);
cptr cat_realloc(cptr mem, int len);
void cat_free(cptr data); 


/* wrappers that die on errors */
cptr Cat_getm(int len);
cptr Cat_realloc(cptr mem, int len);
void Cat_free(cptr data); 
#define	CNEW(p)		((p) = Cat_getm(sizeof(*p)))
#define CFREE(p)	do { free(p);  (p) = 0; } while (0);

#endif /* __CAT_AUX_H */
