#ifndef __CAT_PACK_H
#define __CAT_PACK_H
#include "cat_aux.h"

/* 
   "bhwacslp"

   b - byte
   h - half-word
   w - word
   a - array (32-byte unsigned long + that many bytes)
   c - signed 8 bit value 
   s - signed 16 bit value
   l - signed 32 bit value
   p - (unpack only) value is a pointer to a pointer.  Generate the buffer
       to hold the data.
 */

int cat_pack( cptr buf, char *fmt, ... ); 

int cat_unpack( cptr buf, char *fmt, ... );

struct cat_bvec
{
  unsigned long len;
  cptr data;
};

#endif /* __CAT_PACK_H */
