/* ether.h */

/* Ethernet definitions and constants */

#define	EP_MAXMULTI	  10	/* multicast address table size		*/

#define	EP_MINLEN	  60	/* minimum packet length		*/
#define	EP_DLEN		1500	/* length of data field ep		*/
#define	EP_HLEN		  14	/* size of Ethernet header		*/
#define	EP_ALEN		   6	/* number of octets in physical address	*/
#define	EP_CRC		   4	/* ether CRC (trailer)			*/
#define	EP_MAXLEN	EP_HLEN+EP_DLEN
typedef	unsigned char	Eaddr[EP_ALEN]; /* a physical Ethernet address	*/
#define	EP_RETRY	3	/* number of times to retry xmit errors	*/
#define	EP_BRC	"\377\377\377\377\377\377"/* Ethernet broadcast address	*/
#define EP_RTO 		300	/* time out in seconds for reads	*/

#define	EPT_LOOP	0x0060		/* type: Loopback		*/
#define	EPT_PUP		0x0200		/* type: Xerox PUP		*/
#define	EPT_IP		0x0800		/* type: Internet Protocol	*/
#define	EPT_ARP		0x0806		/* type: ARP			*/
#define	EPT_RARP	0x8035		/* type: Reverse ARP		*/

struct	ep {			/* ethernet header			*/
	Eaddr	ep_dst;		/* destination host address		*/
	Eaddr	ep_src;		/* source host address			*/
	unsigned short	ep_type;/* Ethernet packet type (see below)	*/
	char    ep_data[EP_DLEN];       /* data in the packet           */
};
