#ifndef __setbyteorder_h
#define __setbyteorder_h

#if B_ORDER == B_ENDIAN
#define N2HL(x) (x)
#define H2NL(x) (x)
#define N2HS(x) (x)
#define H2NS(x) (x)
#else
#define N2HL(x) ((((x) & 0xFF000000) >> 24) | \
	         (((x) & 0xFF0000) >> 8) | \
	         (((x) & 0xFF00) << 8) | \
		 (((x) & 0xFF) << 24) )
#define N2HS(x) ( (((x) & 0xFF00) >> 8) | (((x) & 0xFF) << 8) )
#define H2NL(x) N2HL(x)
#define H2NS(x) N2HS(x)
#endif


int packet_ntoh(struct ep *); 
int arp_ntoh(struct arp *); 
int ip_ntoh(struct ip *); 
int iph_ntoh(struct ip *); 
int tcp_ntoh(struct tcp *); 
int udp_ntoh(struct udp *); 
int icmp_ntoh(struct icmp *); 

#endif /* __setbyteorder_h */
