#ifndef __sniff_print_h
#define __sniff_print_h

struct addrent { 
  IPaddr ipaddr; 
  Eaddr  eaddr; 
  char   hostname[25]; 
};
extern struct addrent addrtable[]; 
 
int print_verbose(struct ep *);
int print_xverbose(struct ep *, int, int);

int print_eh(struct ep *pep, int); 
int print_arp(struct arp *pa);
int print_ip(struct ip *pip); 
int print_iph(struct ip *pip);
int print_icmp(struct icmp *ich, int len);
int print_tcp(struct tcp *th, int len); 
int print_udp(struct udp *uh, int len); 
int print_data(caddr_t data, int len); 

char *host_by_ip(IPaddr); 
char *host_by_eth(Eaddr); 

#define MAXPRLEN	40


/* Miscilaneous functions */
#define ETYPE(pep) ((pep)->ep_type)
#define ISBRC(pep) (!memcmp((pep)->ep_dst, EP_BRC, sizeof(Eaddr)))
#define ISARP(pep) ((pep)->ep_type == EPT_ARP)
#define ISRARP(pep) ((pep)->ep_type == EPT_RARP)
#define ISIP(pep)  ((pep)->ep_type == EPT_IP)
#define IPPROTO(pep) (((struct ip *)((pep)->ep_data))->ip_proto)
#define ISTCP(pep) (ISIP(pep) && IPPROTO(pep) == IPT_TCP)
#define ISUDP(pep) (ISIP(pep) && IPPROTO(pep) == IPT_UDP)
#define ISICMP(pep) (ISIP(pep) && IPPROTO(pep) == IPT_ICMP)
#define IP_DATA(pip) ((caddr_t) pip + IP_HLEN(pip))

int tcp_service(struct ep *); 
int udp_service(struct ep *); 
#define ISBOOTP(pep) ((udp_service(pep) == UDPS_BOOTPS) || \
		      (udp_service(pep) == UDPS_BOOTPC))


#endif /* __sniff_print_h */
