#ifndef __TCP_H
#define __TCP_H

/* A hack to get the tcp structure */
struct tcp { 

  unsigned short t_src;
  unsigned short t_dst;
  unsigned long  t_seq;
  unsigned long  t_ack;
  unsigned char  t_hlen;
  unsigned char  t_code;
  unsigned short t_window;
  unsigned short t_cksum;
  unsigned short t_urg;
  char           t_data[1]; 
};  

#define TCPF_URG 0x20
#define TCPF_ACK 0x10
#define TCPF_PSH 0x8
#define TCPF_RST 0x4
#define TCPF_SYN 0x2
#define TCPF_FIN 0x1

#define TCPO_EOP 0
#define TCPO_NOP 1
#define TCPO_MSS 2
#define TCPO_WSF 3
#define TCPO_TIM 8

#define TCP_HLEN(th)	((th)->t_hlen >> 2)
#define TCP_DATA(th)	((caddr_t)th + TCP_HLEN(th))
#define TCP_HSIZ	20

#endif __TCP_H
