/* udp.h */

/* User Datagram Protocol (UDP) constants and formats */

#define	U_HLEN	8		/* UDP header length in bytes		*/
#define UDP_HSIZ U_HLEN

/* maximum data in UDP packet	*/
#define	U_MAXLEN	(IP_MAXLEN-(IP_MINHLEN<<2)-U_HLEN)

struct	udp {				/* message format of DARPA UDP	*/
	unsigned short	u_src;		/* source UDP port number	*/
	unsigned short	u_dst;		/* destination UDP port number	*/
	unsigned short	u_len;		/* length of UDP data		*/
	unsigned short	u_cksum;	/* UDP checksum (0 => none)	*/
	char	u_data[U_MAXLEN];	/* data in UDP message		*/
};

/* UDP constants */

#define	ULPORT		2050	/* initial UDP local "port" number	*/

/* assigned UDP port numbers */

#define	UP_ECHO		7	/* echo server				*/
#define	UP_DISCARD	9	/* discard packet			*/
#define	UP_USERS	11	/* users server				*/
#define	UP_DAYTIME	13	/* day and time server			*/
#define	UP_QOTD		17	/* quote of the day server		*/
#define	UP_CHARGEN	19	/* character generator			*/
#define	UP_TIME		37	/* time server				*/
#define	UP_WHOIS	43	/* who is server (user information)	*/
#define	UP_DNAME	53	/* domain name server			*/
#define	UP_TFTP		69	/* trivial file transfer protocol server*/
#define	UP_RWHO		513	/* remote who server (ruptime)		*/
#define	UP_RIP		520	/* route information exchange (RIP)	*/
