/* -*- C -*- $Id$ */

/******  Code generated by the IX IDL Compiler *******
 * The IX IDL compiler has been developed by Intel Corp. in order
 * to work in conjunction with OMS communication infrastucture and
 * is based on freely available TAO IDL compiler developed by
 * the Center for Distributed Object Computing at
 * Washington University, St. Louis.
 *
 * Information about TAO IDL compiler is available at:
 *                 http://www.cs.wustl.edu/~schmidt/TAO.html
 */

#include <stdlib.h>

#include "ingress_ace_sk_c.h"
#include "ingress_ace_cc_c.h"


/**=================================================
 * Start definitions for interface portMgmt
 *================================================*/


/* Server initialization function for portMgmt interface */
ix_error sk_portMgmt_init(ix_base_t* basep, ix_cap* capp)
{
  static const char localFunctionName[] = "sk_portMgmt_init";
  /* static const char* localInterfaceName = portMgmt_intName; */
  
  VMT_CrossCallEntry* pVMTCCEntry;
  CC_VMT_portMgmt* pCCVMT;
  ix_error err = 0;
  
  if(isIDLTokenInitialized(basep) != 0 )
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is already initialized!", localFunctionName);
    
    goto err_label1;
  }
  else
  {
    memset(basep, 0, sizeof(ix_base_t));
  };
  
  pCCVMT = (CC_VMT_portMgmt*) malloc(sizeof(CC_VMT_portMgmt));
  if(pCCVMT == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Crosscall VMT allocation failed!", localFunctionName);
    
    goto err_label1;
  };
  
  /* Intialize the crosscall VMT */
  
  basep->_pVMTCrossCall = pCCVMT;
  
  pCCVMT->_pCC_portMgmt_portGetPorts = portMgmt_portGetPorts;
  pCCVMT->_pCC_portMgmt_portGetConfig = portMgmt_portGetConfig;
  pCCVMT->_pCC_portMgmt_portSetConfig = portMgmt_portSetConfig;
  pCCVMT->_pCC_portMgmt_portEnable = portMgmt_portEnable;
  pCCVMT->_pCC_portMgmt_portDisable = portMgmt_portDisable;
  pCCVMT->_pCC_portMgmt_portGetFlags = portMgmt_portGetFlags;
  pCCVMT->_pCC_portMgmt_portSetFlags = portMgmt_portSetFlags;
  pCCVMT->_pCC_portMgmt_portAddMacAddrFilter = portMgmt_portAddMacAddrFilter;
  pCCVMT->_pCC_portMgmt_portRemoveMacAddrFilter = portMgmt_portRemoveMacAddrFilter;
  pCCVMT->_pCC_portMgmt_portSetMacAddr = portMgmt_portSetMacAddr;
  pCCVMT->_pCC_portMgmt_portGetMacAddr = portMgmt_portGetMacAddr;
  pCCVMT->_pCC_portMgmt_portSetPromiscMode = portMgmt_portSetPromiscMode;
  pCCVMT->_pCC_portMgmt_portClearPromiscMode = portMgmt_portClearPromiscMode;
  pCCVMT->_pCC_portMgmt_portClearStats = portMgmt_portClearStats;
  pCCVMT->_pCC_portMgmt_portGetSnmpStats = portMgmt_portGetSnmpStats;
  
  /* crosscall table initialization */
  basep->_vVMTCrossCallSize = sizeof(CC_VMT_portMgmt)/sizeof(idl_ixa_c_crossCall_fptr);
  pVMTCCEntry = (VMT_CrossCallEntry*) malloc(basep->_vVMTCrossCallSize * sizeof(VMT_CrossCallEntry));
  if(pVMTCCEntry == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Crosscall VMT table allocation failed!", localFunctionName);
    
    goto err_label1;
  };
  
  /* Intialize the crosscall VMT table entries */
  
  basep->_pVMTCrossCallTable = pVMTCCEntry;
  
  pVMTCCEntry->_vName = portMgmt_portGetPorts_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_portMgmt_portGetPorts;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_portMgmt_portGetPorts;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portGetConfig_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_portMgmt_portGetConfig;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_portMgmt_portGetConfig;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portSetConfig_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_portMgmt_portSetConfig;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_portMgmt_portSetConfig;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portEnable_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_portMgmt_portEnable;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_portMgmt_portEnable;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portDisable_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_portMgmt_portDisable;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_portMgmt_portDisable;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portGetFlags_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_portMgmt_portGetFlags;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_portMgmt_portGetFlags;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portSetFlags_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_portMgmt_portSetFlags;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_portMgmt_portSetFlags;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portAddMacAddrFilter_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_portMgmt_portAddMacAddrFilter;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_portMgmt_portAddMacAddrFilter;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portRemoveMacAddrFilter_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_portMgmt_portRemoveMacAddrFilter;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_portMgmt_portRemoveMacAddrFilter;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portSetMacAddr_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_portMgmt_portSetMacAddr;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_portMgmt_portSetMacAddr;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portGetMacAddr_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_portMgmt_portGetMacAddr;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_portMgmt_portGetMacAddr;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portSetPromiscMode_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_portMgmt_portSetPromiscMode;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_portMgmt_portSetPromiscMode;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portClearPromiscMode_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_portMgmt_portClearPromiscMode;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_portMgmt_portClearPromiscMode;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portClearStats_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_portMgmt_portClearStats;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_portMgmt_portClearStats;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = portMgmt_portGetSnmpStats_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_portMgmt_portGetSnmpStats;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_portMgmt_portGetSnmpStats;
  pVMTCCEntry++;
  
  idl_ixa_c_qsort(basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  
  
  basep->m_pCap = capp;
  
  
  /**=================================================
   * Register the dispatch function 
   *================================================*/
  err = ix_dx_reg_dispatch(capp, /* Pointer to a ix_cap structure */
    portMgmt_intName, /* GUID of the interface */
    idl_ixa_c_dispatch, /* Dispatch function */
    (void*)basep); /* A ix_base_t* passed as a cookie */
    
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dx_reg_dispatchfailed!", localFunctionName);
    
    goto err_label1;
  };
  
  basep->_vTokenType = IDL_IXA_C_SERVER;
  basep->_pInterfaceName = portMgmt_intName;
  basep->_vInitialized = 1;
  basep->_vInitExtraCheck = isIDLTokenInitialized;
  
  /**=================================================
   * TO DO: Add your code here!!!
   *================================================*/
  
err_label1:
  if(basep->_vInitialized == 0 )
  {
    basep->_vTokenType = IDL_IXA_C_NONE;
    
    if(basep->_pVMTCrossCallTable != 0)
      free(basep->_pVMTCrossCallTable);
    basep->_vVMTCrossCallSize = 0;
    if(basep->_pVMTCrossCall != 0)
      free(basep->_pVMTCrossCall);
    
  };
  return err;
}

/* Server finalization function for portMgmt interface */
ix_error sk_portMgmt_fini(ix_base_t* basep)
{
  static const char localFunctionName[] = "sk_portMgmt_fini";
  static const char* localInterfaceName = portMgmt_intName;
  
  ix_error err = 0;
  
  if(isIDLTokenInitialized(basep) == 0 )
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is not initialized!", localFunctionName);
    
    goto err_label1;
  };
  if(basep->_vTokenType != IDL_IXA_C_SERVER)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is not of SERVER type!", localFunctionName);
    
    goto err_label1;
  };
  if(basep->_pInterfaceName != localInterfaceName)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token has not been intialized for this interface type!", localFunctionName);
    
    goto err_label1;
  };
  /**=================================================
   * TO DO: Add your code here!!!
   *================================================*/
  
  /**=================================================
   * Unregister the dispatch function 
   *================================================*/
  /*
  err = ix_dx_unreg_dispatch(portMgmt_intName);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Unregister function failed!", localFunctionName);
    
    goto err_label1;
  };
  */
  
  basep->_vTokenType = IDL_IXA_C_NONE;
  
  free(basep->_pVMTCrossCallTable);
  basep->_vVMTCrossCallSize = 0;
  free(basep->_pVMTCrossCall);
  memset(basep, 0, sizeof(ix_base_t));
  
err_label1:
  return err;
}

/* Accessor function for crosscall VMT */
extern ix_error getCCVMT_portMgmt(const ix_base_t* basep, CC_VMT_portMgmt** pInterfaceCCVMT)
{
  static const char localFunctionName[] = "CB_VMT_portMgmt";
  static const char* localInterfaceName = portMgmt_intName;
  
  ix_error err = 0;
  
  *pInterfaceCCVMT = 0;
  if(isIDLTokenInitialized(basep) == 0 )
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is not initialized!", localFunctionName);
    
    goto err_label1;
  };
  if(basep->_vTokenType != IDL_IXA_C_SERVER)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is not of SERVER type!", localFunctionName);
    
    goto err_label1;
  };
  if(basep->_pInterfaceName != localInterfaceName)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token has not been intialized for this interface type!", localFunctionName);
    
    goto err_label1;
  };
  
  *pInterfaceCCVMT = (CC_VMT_portMgmt*) basep->_pVMTCrossCall;
  
err_label1:
  return err;
}


/**=================================================
 * Start invoke functions definitions for interface portMgmt
 *================================================*/


/* Definition of invoke function for portMgmt::portGetPorts operation */
extern ix_error invoke_portMgmt_portGetPorts(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_portMgmt_portGetPorts";
  static const char* localOperationName = portMgmt_portGetPorts_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    tAPortConfig ports;
    
    ix_sds aReplySds = 0;
    ix_commDesc_t aReplyCD;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    err = init_ixa_c_seq_tPortConfig(&ports);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - sequence initialization failed for tAPortConfig!", localFunctionName);
      goto err_label1;
    };
    
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((portMgmt_portGetPorts_fptr) pFunc)(basep, &ports);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for portMgmt_portGetPorts operation failed!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Create and compose a reply message portMgmt_portGetPorts
     *================================================*/
    err = ix_sds_new(&aReplySds);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_sds_new failed!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Store two integers at the beginning of SDS 
     *================================================*/
    err = ix_sds_r_int(aReplySds, 0);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - SDS header marshaling failed!", localFunctionName);
      goto err_label2;
    };
    err = ix_sds_r_int(aReplySds, 0);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - SDS header marshaling failed!", localFunctionName);
      goto err_label2;
    };
    
    /**=================================================
     * Marshal inout and out parameters 
     *================================================*/
    err = ix_sds_r_ixa_c_seq_tPortConfig(aReplySds, &ports);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for ports!", localFunctionName);
      goto err_label2;
    };
    
    err = ix_oms_formulate_reply(aSds, &aReplyCD);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_oms_formulate_reply failed!", localFunctionName);
      goto err_label2;
    };
    
    err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
      aReplyCD, /* Communication descriptor */
      &aReplySds, /* Message to send */
      OMS_CT_RETURN, /* Calltype: tells muxer how to handle call */
      NULL, /* Callback: not used for return */
      0); /* Timeout: not aplicable for a return  */
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_dxProcMessage failed!", localFunctionName);
      goto err_label2;
    };
    /**=================================================
     * Jump directly to finalization of the variables 
     *================================================*/
    goto err_label1;
    
    
  err_label2:
    {
      if(aReplySds)
      {
        /**=================================================
         * Delete the reply sds
         *================================================*/
        ix_error err1 = ix_sds_del(aReplySds);
        if(err1) err = ix_error_new(0, 0, err1, 
          "%s - ix_sds_del failed!", localFunctionName);
      };
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    err = fini_ixa_c_seq_tPortConfig(&ports);
    if(err)
    {
      ix_sds_del(aSds);
      ix_sds_del(aReplySds);
      return ix_error_new(0, 0, err, 
        "%s - sequence finalization failed for tAPortConfig!", localFunctionName);
    };
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}

/* Definition of invoke function for portMgmt::portGetConfig operation */
extern ix_error invoke_portMgmt_portGetConfig(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_portMgmt_portGetConfig";
  static const char* localOperationName = portMgmt_portGetConfig_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    long portNum;
    tPortConfig portConfig;
    
    ix_sds aReplySds = 0;
    ix_commDesc_t aReplyCD;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    err = init_tPortConfig(&portConfig);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - structure initialization failed for tPortConfig!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_long(aSds,&portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portNum!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((portMgmt_portGetConfig_fptr) pFunc)(basep, portNum, &portConfig);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for portMgmt_portGetConfig operation failed!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Create and compose a reply message portMgmt_portGetConfig
     *================================================*/
    err = ix_sds_new(&aReplySds);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_sds_new failed!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Store two integers at the beginning of SDS 
     *================================================*/
    err = ix_sds_r_int(aReplySds, 0);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - SDS header marshaling failed!", localFunctionName);
      goto err_label2;
    };
    err = ix_sds_r_int(aReplySds, 0);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - SDS header marshaling failed!", localFunctionName);
      goto err_label2;
    };
    
    /**=================================================
     * Marshal inout and out parameters 
     *================================================*/
    err = ix_sds_r_tPortConfig(aReplySds, &portConfig);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portConfig!", localFunctionName);
      goto err_label2;
    };
    
    err = ix_oms_formulate_reply(aSds, &aReplyCD);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_oms_formulate_reply failed!", localFunctionName);
      goto err_label2;
    };
    
    err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
      aReplyCD, /* Communication descriptor */
      &aReplySds, /* Message to send */
      OMS_CT_RETURN, /* Calltype: tells muxer how to handle call */
      NULL, /* Callback: not used for return */
      0); /* Timeout: not aplicable for a return  */
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_dxProcMessage failed!", localFunctionName);
      goto err_label2;
    };
    /**=================================================
     * Jump directly to finalization of the variables 
     *================================================*/
    goto err_label1;
    
    
  err_label2:
    {
      if(aReplySds)
      {
        /**=================================================
         * Delete the reply sds
         *================================================*/
        ix_error err1 = ix_sds_del(aReplySds);
        if(err1) err = ix_error_new(0, 0, err1, 
          "%s - ix_sds_del failed!", localFunctionName);
      };
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    err = fini_tPortConfig(&portConfig);
    if(err)
    {
      ix_sds_del(aSds);
      ix_sds_del(aReplySds);
      return ix_error_new(0, 0, err, 
        "%s - structure finalization failed for tPortConfig!", localFunctionName);
    };
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}

/* Definition of invoke function for portMgmt::portSetConfig operation */
extern ix_error invoke_portMgmt_portSetConfig(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_portMgmt_portSetConfig";
  static const char* localOperationName = portMgmt_portSetConfig_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    long portNum;
    tPortConfig portConfig;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    err = init_tPortConfig(&portConfig);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - structure initialization failed for tPortConfig!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_long(aSds,&portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portNum!", localFunctionName);
      goto err_label1;
    };
    err = ix_sds_p_tPortConfig(aSds, &portConfig);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portConfig!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((portMgmt_portSetConfig_fptr) pFunc)(basep, portNum, &portConfig);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for portMgmt_portSetConfig operation failed!", localFunctionName);
      goto err_label1;
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    err = fini_tPortConfig(&portConfig);
    if(err)
    {
      ix_sds_del(aSds);
      return ix_error_new(0, 0, err, 
        "%s - structure finalization failed for tPortConfig!", localFunctionName);
    };
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}

/* Definition of invoke function for portMgmt::portEnable operation */
extern ix_error invoke_portMgmt_portEnable(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_portMgmt_portEnable";
  static const char* localOperationName = portMgmt_portEnable_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    long portNum;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_long(aSds,&portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portNum!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((portMgmt_portEnable_fptr) pFunc)(basep, portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for portMgmt_portEnable operation failed!", localFunctionName);
      goto err_label1;
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}

/* Definition of invoke function for portMgmt::portDisable operation */
extern ix_error invoke_portMgmt_portDisable(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_portMgmt_portDisable";
  static const char* localOperationName = portMgmt_portDisable_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    long portNum;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_long(aSds,&portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portNum!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((portMgmt_portDisable_fptr) pFunc)(basep, portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for portMgmt_portDisable operation failed!", localFunctionName);
      goto err_label1;
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}

/* Definition of invoke function for portMgmt::portGetFlags operation */
extern ix_error invoke_portMgmt_portGetFlags(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_portMgmt_portGetFlags";
  static const char* localOperationName = portMgmt_portGetFlags_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    long portNum;
    unsigned long flags;
    
    ix_sds aReplySds = 0;
    ix_commDesc_t aReplyCD;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_long(aSds,&portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portNum!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((portMgmt_portGetFlags_fptr) pFunc)(basep, portNum, &flags);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for portMgmt_portGetFlags operation failed!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Create and compose a reply message portMgmt_portGetFlags
     *================================================*/
    err = ix_sds_new(&aReplySds);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_sds_new failed!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Store two integers at the beginning of SDS 
     *================================================*/
    err = ix_sds_r_int(aReplySds, 0);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - SDS header marshaling failed!", localFunctionName);
      goto err_label2;
    };
    err = ix_sds_r_int(aReplySds, 0);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - SDS header marshaling failed!", localFunctionName);
      goto err_label2;
    };
    
    /**=================================================
     * Marshal inout and out parameters 
     *================================================*/
    err = ix_sds_r_ulong(aReplySds,flags);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for flags!", localFunctionName);
      goto err_label2;
    };
    
    err = ix_oms_formulate_reply(aSds, &aReplyCD);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_oms_formulate_reply failed!", localFunctionName);
      goto err_label2;
    };
    
    err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
      aReplyCD, /* Communication descriptor */
      &aReplySds, /* Message to send */
      OMS_CT_RETURN, /* Calltype: tells muxer how to handle call */
      NULL, /* Callback: not used for return */
      0); /* Timeout: not aplicable for a return  */
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_dxProcMessage failed!", localFunctionName);
      goto err_label2;
    };
    /**=================================================
     * Jump directly to finalization of the variables 
     *================================================*/
    goto err_label1;
    
    
  err_label2:
    {
      if(aReplySds)
      {
        /**=================================================
         * Delete the reply sds
         *================================================*/
        ix_error err1 = ix_sds_del(aReplySds);
        if(err1) err = ix_error_new(0, 0, err1, 
          "%s - ix_sds_del failed!", localFunctionName);
      };
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}

/* Definition of invoke function for portMgmt::portSetFlags operation */
extern ix_error invoke_portMgmt_portSetFlags(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_portMgmt_portSetFlags";
  static const char* localOperationName = portMgmt_portSetFlags_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    long portNum;
    unsigned long flags;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_long(aSds,&portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portNum!", localFunctionName);
      goto err_label1;
    };
    err = ix_sds_p_ulong(aSds,&flags);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for flags!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((portMgmt_portSetFlags_fptr) pFunc)(basep, portNum, flags);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for portMgmt_portSetFlags operation failed!", localFunctionName);
      goto err_label1;
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}

/* Definition of invoke function for portMgmt::portAddMacAddrFilter operation */
extern ix_error invoke_portMgmt_portAddMacAddrFilter(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_portMgmt_portAddMacAddrFilter";
  static const char* localOperationName = portMgmt_portAddMacAddrFilter_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    long portNum;
    tMacAddr addr;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    err = init_tMacAddr(&addr);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - structure initialization failed for tMacAddr!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_long(aSds,&portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portNum!", localFunctionName);
      goto err_label1;
    };
    err = ix_sds_p_tMacAddr(aSds, &addr);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for addr!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((portMgmt_portAddMacAddrFilter_fptr) pFunc)(basep, portNum, &addr);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for portMgmt_portAddMacAddrFilter operation failed!", localFunctionName);
      goto err_label1;
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    err = fini_tMacAddr(&addr);
    if(err)
    {
      ix_sds_del(aSds);
      return ix_error_new(0, 0, err, 
        "%s - structure finalization failed for tMacAddr!", localFunctionName);
    };
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}

/* Definition of invoke function for portMgmt::portRemoveMacAddrFilter operation */
extern ix_error invoke_portMgmt_portRemoveMacAddrFilter(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_portMgmt_portRemoveMacAddrFilter";
  static const char* localOperationName = portMgmt_portRemoveMacAddrFilter_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    long portNum;
    tMacAddr addr;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    err = init_tMacAddr(&addr);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - structure initialization failed for tMacAddr!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_long(aSds,&portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portNum!", localFunctionName);
      goto err_label1;
    };
    err = ix_sds_p_tMacAddr(aSds, &addr);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for addr!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((portMgmt_portRemoveMacAddrFilter_fptr) pFunc)(basep, portNum, &addr);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for portMgmt_portRemoveMacAddrFilter operation failed!", localFunctionName);
      goto err_label1;
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    err = fini_tMacAddr(&addr);
    if(err)
    {
      ix_sds_del(aSds);
      return ix_error_new(0, 0, err, 
        "%s - structure finalization failed for tMacAddr!", localFunctionName);
    };
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}

/* Definition of invoke function for portMgmt::portSetMacAddr operation */
extern ix_error invoke_portMgmt_portSetMacAddr(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_portMgmt_portSetMacAddr";
  static const char* localOperationName = portMgmt_portSetMacAddr_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    long portNum;
    tMacAddr addr;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    err = init_tMacAddr(&addr);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - structure initialization failed for tMacAddr!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_long(aSds,&portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portNum!", localFunctionName);
      goto err_label1;
    };
    err = ix_sds_p_tMacAddr(aSds, &addr);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for addr!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((portMgmt_portSetMacAddr_fptr) pFunc)(basep, portNum, &addr);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for portMgmt_portSetMacAddr operation failed!", localFunctionName);
      goto err_label1;
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    err = fini_tMacAddr(&addr);
    if(err)
    {
      ix_sds_del(aSds);
      return ix_error_new(0, 0, err, 
        "%s - structure finalization failed for tMacAddr!", localFunctionName);
    };
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}

/* Definition of invoke function for portMgmt::portGetMacAddr operation */
extern ix_error invoke_portMgmt_portGetMacAddr(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_portMgmt_portGetMacAddr";
  static const char* localOperationName = portMgmt_portGetMacAddr_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    long portNum;
    tMacAddr addr;
    
    ix_sds aReplySds = 0;
    ix_commDesc_t aReplyCD;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    err = init_tMacAddr(&addr);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - structure initialization failed for tMacAddr!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_long(aSds,&portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portNum!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((portMgmt_portGetMacAddr_fptr) pFunc)(basep, portNum, &addr);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for portMgmt_portGetMacAddr operation failed!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Create and compose a reply message portMgmt_portGetMacAddr
     *================================================*/
    err = ix_sds_new(&aReplySds);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_sds_new failed!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Store two integers at the beginning of SDS 
     *================================================*/
    err = ix_sds_r_int(aReplySds, 0);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - SDS header marshaling failed!", localFunctionName);
      goto err_label2;
    };
    err = ix_sds_r_int(aReplySds, 0);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - SDS header marshaling failed!", localFunctionName);
      goto err_label2;
    };
    
    /**=================================================
     * Marshal inout and out parameters 
     *================================================*/
    err = ix_sds_r_tMacAddr(aReplySds, &addr);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for addr!", localFunctionName);
      goto err_label2;
    };
    
    err = ix_oms_formulate_reply(aSds, &aReplyCD);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_oms_formulate_reply failed!", localFunctionName);
      goto err_label2;
    };
    
    err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
      aReplyCD, /* Communication descriptor */
      &aReplySds, /* Message to send */
      OMS_CT_RETURN, /* Calltype: tells muxer how to handle call */
      NULL, /* Callback: not used for return */
      0); /* Timeout: not aplicable for a return  */
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_dxProcMessage failed!", localFunctionName);
      goto err_label2;
    };
    /**=================================================
     * Jump directly to finalization of the variables 
     *================================================*/
    goto err_label1;
    
    
  err_label2:
    {
      if(aReplySds)
      {
        /**=================================================
         * Delete the reply sds
         *================================================*/
        ix_error err1 = ix_sds_del(aReplySds);
        if(err1) err = ix_error_new(0, 0, err1, 
          "%s - ix_sds_del failed!", localFunctionName);
      };
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    err = fini_tMacAddr(&addr);
    if(err)
    {
      ix_sds_del(aSds);
      ix_sds_del(aReplySds);
      return ix_error_new(0, 0, err, 
        "%s - structure finalization failed for tMacAddr!", localFunctionName);
    };
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}

/* Definition of invoke function for portMgmt::portSetPromiscMode operation */
extern ix_error invoke_portMgmt_portSetPromiscMode(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_portMgmt_portSetPromiscMode";
  static const char* localOperationName = portMgmt_portSetPromiscMode_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    long portNum;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_long(aSds,&portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portNum!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((portMgmt_portSetPromiscMode_fptr) pFunc)(basep, portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for portMgmt_portSetPromiscMode operation failed!", localFunctionName);
      goto err_label1;
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}

/* Definition of invoke function for portMgmt::portClearPromiscMode operation */
extern ix_error invoke_portMgmt_portClearPromiscMode(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_portMgmt_portClearPromiscMode";
  static const char* localOperationName = portMgmt_portClearPromiscMode_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    long portNum;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_long(aSds,&portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portNum!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((portMgmt_portClearPromiscMode_fptr) pFunc)(basep, portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for portMgmt_portClearPromiscMode operation failed!", localFunctionName);
      goto err_label1;
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}

/* Definition of invoke function for portMgmt::portClearStats operation */
extern ix_error invoke_portMgmt_portClearStats(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_portMgmt_portClearStats";
  static const char* localOperationName = portMgmt_portClearStats_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    long portNum;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_long(aSds,&portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portNum!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((portMgmt_portClearStats_fptr) pFunc)(basep, portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for portMgmt_portClearStats operation failed!", localFunctionName);
      goto err_label1;
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}

/* Definition of invoke function for portMgmt::portGetSnmpStats operation */
extern ix_error invoke_portMgmt_portGetSnmpStats(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_portMgmt_portGetSnmpStats";
  static const char* localOperationName = portMgmt_portGetSnmpStats_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    long portNum;
    tPortSnmpStats stats;
    
    ix_sds aReplySds = 0;
    ix_commDesc_t aReplyCD;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    err = init_tPortSnmpStats(&stats);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - structure initialization failed for tPortSnmpStats!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_long(aSds,&portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portNum!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((portMgmt_portGetSnmpStats_fptr) pFunc)(basep, portNum, &stats);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for portMgmt_portGetSnmpStats operation failed!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Create and compose a reply message portMgmt_portGetSnmpStats
     *================================================*/
    err = ix_sds_new(&aReplySds);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_sds_new failed!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Store two integers at the beginning of SDS 
     *================================================*/
    err = ix_sds_r_int(aReplySds, 0);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - SDS header marshaling failed!", localFunctionName);
      goto err_label2;
    };
    err = ix_sds_r_int(aReplySds, 0);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - SDS header marshaling failed!", localFunctionName);
      goto err_label2;
    };
    
    /**=================================================
     * Marshal inout and out parameters 
     *================================================*/
    err = ix_sds_r_tPortSnmpStats(aReplySds, &stats);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for stats!", localFunctionName);
      goto err_label2;
    };
    
    err = ix_oms_formulate_reply(aSds, &aReplyCD);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_oms_formulate_reply failed!", localFunctionName);
      goto err_label2;
    };
    
    err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
      aReplyCD, /* Communication descriptor */
      &aReplySds, /* Message to send */
      OMS_CT_RETURN, /* Calltype: tells muxer how to handle call */
      NULL, /* Callback: not used for return */
      0); /* Timeout: not aplicable for a return  */
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_dxProcMessage failed!", localFunctionName);
      goto err_label2;
    };
    /**=================================================
     * Jump directly to finalization of the variables 
     *================================================*/
    goto err_label1;
    
    
  err_label2:
    {
      if(aReplySds)
      {
        /**=================================================
         * Delete the reply sds
         *================================================*/
        ix_error err1 = ix_sds_del(aReplySds);
        if(err1) err = ix_error_new(0, 0, err1, 
          "%s - ix_sds_del failed!", localFunctionName);
      };
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    err = fini_tPortSnmpStats(&stats);
    if(err)
    {
      ix_sds_del(aSds);
      ix_sds_del(aReplySds);
      return ix_error_new(0, 0, err, 
        "%s - structure finalization failed for tPortSnmpStats!", localFunctionName);
    };
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}


/**=================================================
 * End invoke functions definitions for interface portMgmt
 *================================================*/



/**=================================================
 * End definitions for interface portMgmt
 *================================================*/



/**=================================================
 * Start definitions for interface logicalIfMgmt
 *================================================*/


/* Server initialization function for logicalIfMgmt interface */
ix_error sk_logicalIfMgmt_init(ix_base_t* basep, ix_cap* capp)
{
  static const char localFunctionName[] = "sk_logicalIfMgmt_init";
  /* static const char* localInterfaceName = logicalIfMgmt_intName; */
  
  VMT_CrossCallEntry* pVMTCCEntry;
  CC_VMT_logicalIfMgmt* pCCVMT;
  ix_error err = 0;
  
  if(isIDLTokenInitialized(basep) != 0 )
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is already initialized!", localFunctionName);
    
    goto err_label1;
  }
  else
  {
    memset(basep, 0, sizeof(ix_base_t));
  };
  
  pCCVMT = (CC_VMT_logicalIfMgmt*) malloc(sizeof(CC_VMT_logicalIfMgmt));
  if(pCCVMT == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Crosscall VMT allocation failed!", localFunctionName);
    
    goto err_label1;
  };
  
  /* Intialize the crosscall VMT */
  
  basep->_pVMTCrossCall = pCCVMT;
  
  pCCVMT->_pCC_logicalIfMgmt_ifGetIfs = logicalIfMgmt_ifGetIfs;
  pCCVMT->_pCC_logicalIfMgmt_ifGetConfig = logicalIfMgmt_ifGetConfig;
  pCCVMT->_pCC_logicalIfMgmt_ifSetConfig = logicalIfMgmt_ifSetConfig;
  pCCVMT->_pCC_logicalIfMgmt_ifSetFlags = logicalIfMgmt_ifSetFlags;
  pCCVMT->_pCC_logicalIfMgmt_ifGetFlags = logicalIfMgmt_ifGetFlags;
  pCCVMT->_pCC_logicalIfMgmt_ifAddIf = logicalIfMgmt_ifAddIf;
  pCCVMT->_pCC_logicalIfMgmt_ifRemoveIf = logicalIfMgmt_ifRemoveIf;
  
  /* crosscall table initialization */
  basep->_vVMTCrossCallSize = sizeof(CC_VMT_logicalIfMgmt)/sizeof(idl_ixa_c_crossCall_fptr);
  pVMTCCEntry = (VMT_CrossCallEntry*) malloc(basep->_vVMTCrossCallSize * sizeof(VMT_CrossCallEntry));
  if(pVMTCCEntry == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Crosscall VMT table allocation failed!", localFunctionName);
    
    goto err_label1;
  };
  
  /* Intialize the crosscall VMT table entries */
  
  basep->_pVMTCrossCallTable = pVMTCCEntry;
  
  pVMTCCEntry->_vName = logicalIfMgmt_ifGetIfs_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_logicalIfMgmt_ifGetIfs;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_logicalIfMgmt_ifGetIfs;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = logicalIfMgmt_ifGetConfig_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_logicalIfMgmt_ifGetConfig;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_logicalIfMgmt_ifGetConfig;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = logicalIfMgmt_ifSetConfig_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_logicalIfMgmt_ifSetConfig;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_logicalIfMgmt_ifSetConfig;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = logicalIfMgmt_ifSetFlags_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_logicalIfMgmt_ifSetFlags;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_logicalIfMgmt_ifSetFlags;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = logicalIfMgmt_ifGetFlags_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_logicalIfMgmt_ifGetFlags;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_logicalIfMgmt_ifGetFlags;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = logicalIfMgmt_ifAddIf_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_logicalIfMgmt_ifAddIf;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_logicalIfMgmt_ifAddIf;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = logicalIfMgmt_ifRemoveIf_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_logicalIfMgmt_ifRemoveIf;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_logicalIfMgmt_ifRemoveIf;
  pVMTCCEntry++;
  
  idl_ixa_c_qsort(basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  
  
  basep->m_pCap = capp;
  
  
  /**=================================================
   * Register the dispatch function 
   *================================================*/
  err = ix_dx_reg_dispatch(capp, /* Pointer to a ix_cap structure */
    logicalIfMgmt_intName, /* GUID of the interface */
    idl_ixa_c_dispatch, /* Dispatch function */
    (void*)basep); /* A ix_base_t* passed as a cookie */
    
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dx_reg_dispatchfailed!", localFunctionName);
    
    goto err_label1;
  };
  
  basep->_vTokenType = IDL_IXA_C_SERVER;
  basep->_pInterfaceName = logicalIfMgmt_intName;
  basep->_vInitialized = 1;
  basep->_vInitExtraCheck = isIDLTokenInitialized;
  
  /**=================================================
   * TO DO: Add your code here!!!
   *================================================*/
  
err_label1:
  if(basep->_vInitialized == 0 )
  {
    basep->_vTokenType = IDL_IXA_C_NONE;
    
    if(basep->_pVMTCrossCallTable != 0)
      free(basep->_pVMTCrossCallTable);
    basep->_vVMTCrossCallSize = 0;
    if(basep->_pVMTCrossCall != 0)
      free(basep->_pVMTCrossCall);
    
  };
  return err;
}

/* Server finalization function for logicalIfMgmt interface */
ix_error sk_logicalIfMgmt_fini(ix_base_t* basep)
{
  static const char localFunctionName[] = "sk_logicalIfMgmt_fini";
  static const char* localInterfaceName = logicalIfMgmt_intName;
  
  ix_error err = 0;
  
  if(isIDLTokenInitialized(basep) == 0 )
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is not initialized!", localFunctionName);
    
    goto err_label1;
  };
  if(basep->_vTokenType != IDL_IXA_C_SERVER)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is not of SERVER type!", localFunctionName);
    
    goto err_label1;
  };
  if(basep->_pInterfaceName != localInterfaceName)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token has not been intialized for this interface type!", localFunctionName);
    
    goto err_label1;
  };
  /**=================================================
   * TO DO: Add your code here!!!
   *================================================*/
  
  /**=================================================
   * Unregister the dispatch function 
   *================================================*/
  /*
  err = ix_dx_unreg_dispatch(logicalIfMgmt_intName);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Unregister function failed!", localFunctionName);
    
    goto err_label1;
  };
  */
  
  basep->_vTokenType = IDL_IXA_C_NONE;
  
  free(basep->_pVMTCrossCallTable);
  basep->_vVMTCrossCallSize = 0;
  free(basep->_pVMTCrossCall);
  memset(basep, 0, sizeof(ix_base_t));
  
err_label1:
  return err;
}

/* Accessor function for crosscall VMT */
extern ix_error getCCVMT_logicalIfMgmt(const ix_base_t* basep, CC_VMT_logicalIfMgmt** pInterfaceCCVMT)
{
  static const char localFunctionName[] = "CB_VMT_logicalIfMgmt";
  static const char* localInterfaceName = logicalIfMgmt_intName;
  
  ix_error err = 0;
  
  *pInterfaceCCVMT = 0;
  if(isIDLTokenInitialized(basep) == 0 )
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is not initialized!", localFunctionName);
    
    goto err_label1;
  };
  if(basep->_vTokenType != IDL_IXA_C_SERVER)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is not of SERVER type!", localFunctionName);
    
    goto err_label1;
  };
  if(basep->_pInterfaceName != localInterfaceName)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token has not been intialized for this interface type!", localFunctionName);
    
    goto err_label1;
  };
  
  *pInterfaceCCVMT = (CC_VMT_logicalIfMgmt*) basep->_pVMTCrossCall;
  
err_label1:
  return err;
}


/**=================================================
 * Start invoke functions definitions for interface logicalIfMgmt
 *================================================*/


/* Definition of invoke function for logicalIfMgmt::ifGetIfs operation */
extern ix_error invoke_logicalIfMgmt_ifGetIfs(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_logicalIfMgmt_ifGetIfs";
  static const char* localOperationName = logicalIfMgmt_ifGetIfs_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    long portNum;
    tAIfConfig _cxx_if;
    
    ix_sds aReplySds = 0;
    ix_commDesc_t aReplyCD;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    err = init_ixa_c_seq_tIfConfig(&_cxx_if);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - sequence initialization failed for tAIfConfig!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_long(aSds,&portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portNum!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((logicalIfMgmt_ifGetIfs_fptr) pFunc)(basep, portNum, &_cxx_if);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for logicalIfMgmt_ifGetIfs operation failed!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Create and compose a reply message logicalIfMgmt_ifGetIfs
     *================================================*/
    err = ix_sds_new(&aReplySds);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_sds_new failed!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Store two integers at the beginning of SDS 
     *================================================*/
    err = ix_sds_r_int(aReplySds, 0);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - SDS header marshaling failed!", localFunctionName);
      goto err_label2;
    };
    err = ix_sds_r_int(aReplySds, 0);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - SDS header marshaling failed!", localFunctionName);
      goto err_label2;
    };
    
    /**=================================================
     * Marshal inout and out parameters 
     *================================================*/
    err = ix_sds_r_ixa_c_seq_tIfConfig(aReplySds, &_cxx_if);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for _cxx_if!", localFunctionName);
      goto err_label2;
    };
    
    err = ix_oms_formulate_reply(aSds, &aReplyCD);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_oms_formulate_reply failed!", localFunctionName);
      goto err_label2;
    };
    
    err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
      aReplyCD, /* Communication descriptor */
      &aReplySds, /* Message to send */
      OMS_CT_RETURN, /* Calltype: tells muxer how to handle call */
      NULL, /* Callback: not used for return */
      0); /* Timeout: not aplicable for a return  */
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_dxProcMessage failed!", localFunctionName);
      goto err_label2;
    };
    /**=================================================
     * Jump directly to finalization of the variables 
     *================================================*/
    goto err_label1;
    
    
  err_label2:
    {
      if(aReplySds)
      {
        /**=================================================
         * Delete the reply sds
         *================================================*/
        ix_error err1 = ix_sds_del(aReplySds);
        if(err1) err = ix_error_new(0, 0, err1, 
          "%s - ix_sds_del failed!", localFunctionName);
      };
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    err = fini_ixa_c_seq_tIfConfig(&_cxx_if);
    if(err)
    {
      ix_sds_del(aSds);
      ix_sds_del(aReplySds);
      return ix_error_new(0, 0, err, 
        "%s - sequence finalization failed for tAIfConfig!", localFunctionName);
    };
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}

/* Definition of invoke function for logicalIfMgmt::ifGetConfig operation */
extern ix_error invoke_logicalIfMgmt_ifGetConfig(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_logicalIfMgmt_ifGetConfig";
  static const char* localOperationName = logicalIfMgmt_ifGetConfig_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    long portNum;
    long ifNum;
    tIfConfig ifCfg;
    
    ix_sds aReplySds = 0;
    ix_commDesc_t aReplyCD;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    err = init_tIfConfig(&ifCfg);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - structure initialization failed for tIfConfig!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_long(aSds,&portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portNum!", localFunctionName);
      goto err_label1;
    };
    err = ix_sds_p_long(aSds,&ifNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for ifNum!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((logicalIfMgmt_ifGetConfig_fptr) pFunc)(basep, portNum, ifNum, &ifCfg);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for logicalIfMgmt_ifGetConfig operation failed!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Create and compose a reply message logicalIfMgmt_ifGetConfig
     *================================================*/
    err = ix_sds_new(&aReplySds);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_sds_new failed!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Store two integers at the beginning of SDS 
     *================================================*/
    err = ix_sds_r_int(aReplySds, 0);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - SDS header marshaling failed!", localFunctionName);
      goto err_label2;
    };
    err = ix_sds_r_int(aReplySds, 0);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - SDS header marshaling failed!", localFunctionName);
      goto err_label2;
    };
    
    /**=================================================
     * Marshal inout and out parameters 
     *================================================*/
    err = ix_sds_r_tIfConfig(aReplySds, &ifCfg);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for ifCfg!", localFunctionName);
      goto err_label2;
    };
    
    err = ix_oms_formulate_reply(aSds, &aReplyCD);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_oms_formulate_reply failed!", localFunctionName);
      goto err_label2;
    };
    
    err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
      aReplyCD, /* Communication descriptor */
      &aReplySds, /* Message to send */
      OMS_CT_RETURN, /* Calltype: tells muxer how to handle call */
      NULL, /* Callback: not used for return */
      0); /* Timeout: not aplicable for a return  */
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_dxProcMessage failed!", localFunctionName);
      goto err_label2;
    };
    /**=================================================
     * Jump directly to finalization of the variables 
     *================================================*/
    goto err_label1;
    
    
  err_label2:
    {
      if(aReplySds)
      {
        /**=================================================
         * Delete the reply sds
         *================================================*/
        ix_error err1 = ix_sds_del(aReplySds);
        if(err1) err = ix_error_new(0, 0, err1, 
          "%s - ix_sds_del failed!", localFunctionName);
      };
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    err = fini_tIfConfig(&ifCfg);
    if(err)
    {
      ix_sds_del(aSds);
      ix_sds_del(aReplySds);
      return ix_error_new(0, 0, err, 
        "%s - structure finalization failed for tIfConfig!", localFunctionName);
    };
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}

/* Definition of invoke function for logicalIfMgmt::ifSetConfig operation */
extern ix_error invoke_logicalIfMgmt_ifSetConfig(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_logicalIfMgmt_ifSetConfig";
  static const char* localOperationName = logicalIfMgmt_ifSetConfig_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    long portNum;
    long ifNum;
    tIfConfig ifCfg;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    err = init_tIfConfig(&ifCfg);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - structure initialization failed for tIfConfig!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_long(aSds,&portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portNum!", localFunctionName);
      goto err_label1;
    };
    err = ix_sds_p_long(aSds,&ifNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for ifNum!", localFunctionName);
      goto err_label1;
    };
    err = ix_sds_p_tIfConfig(aSds, &ifCfg);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for ifCfg!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((logicalIfMgmt_ifSetConfig_fptr) pFunc)(basep, portNum, ifNum, &ifCfg);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for logicalIfMgmt_ifSetConfig operation failed!", localFunctionName);
      goto err_label1;
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    err = fini_tIfConfig(&ifCfg);
    if(err)
    {
      ix_sds_del(aSds);
      return ix_error_new(0, 0, err, 
        "%s - structure finalization failed for tIfConfig!", localFunctionName);
    };
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}

/* Definition of invoke function for logicalIfMgmt::ifSetFlags operation */
extern ix_error invoke_logicalIfMgmt_ifSetFlags(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_logicalIfMgmt_ifSetFlags";
  static const char* localOperationName = logicalIfMgmt_ifSetFlags_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    long portNum;
    long ifNum;
    unsigned long flags;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_long(aSds,&portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portNum!", localFunctionName);
      goto err_label1;
    };
    err = ix_sds_p_long(aSds,&ifNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for ifNum!", localFunctionName);
      goto err_label1;
    };
    err = ix_sds_p_ulong(aSds,&flags);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for flags!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((logicalIfMgmt_ifSetFlags_fptr) pFunc)(basep, portNum, ifNum, flags);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for logicalIfMgmt_ifSetFlags operation failed!", localFunctionName);
      goto err_label1;
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}

/* Definition of invoke function for logicalIfMgmt::ifGetFlags operation */
extern ix_error invoke_logicalIfMgmt_ifGetFlags(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_logicalIfMgmt_ifGetFlags";
  static const char* localOperationName = logicalIfMgmt_ifGetFlags_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    long portNum;
    long ifNum;
    unsigned long flags;
    
    ix_sds aReplySds = 0;
    ix_commDesc_t aReplyCD;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_long(aSds,&portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portNum!", localFunctionName);
      goto err_label1;
    };
    err = ix_sds_p_long(aSds,&ifNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for ifNum!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((logicalIfMgmt_ifGetFlags_fptr) pFunc)(basep, portNum, ifNum, &flags);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for logicalIfMgmt_ifGetFlags operation failed!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Create and compose a reply message logicalIfMgmt_ifGetFlags
     *================================================*/
    err = ix_sds_new(&aReplySds);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_sds_new failed!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Store two integers at the beginning of SDS 
     *================================================*/
    err = ix_sds_r_int(aReplySds, 0);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - SDS header marshaling failed!", localFunctionName);
      goto err_label2;
    };
    err = ix_sds_r_int(aReplySds, 0);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - SDS header marshaling failed!", localFunctionName);
      goto err_label2;
    };
    
    /**=================================================
     * Marshal inout and out parameters 
     *================================================*/
    err = ix_sds_r_ulong(aReplySds,flags);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for flags!", localFunctionName);
      goto err_label2;
    };
    
    err = ix_oms_formulate_reply(aSds, &aReplyCD);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_oms_formulate_reply failed!", localFunctionName);
      goto err_label2;
    };
    
    err = ix_dxProcMessage(basep->m_pCap, /* Pointer to a ix_cap structure */
      aReplyCD, /* Communication descriptor */
      &aReplySds, /* Message to send */
      OMS_CT_RETURN, /* Calltype: tells muxer how to handle call */
      NULL, /* Callback: not used for return */
      0); /* Timeout: not aplicable for a return  */
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - ix_dxProcMessage failed!", localFunctionName);
      goto err_label2;
    };
    /**=================================================
     * Jump directly to finalization of the variables 
     *================================================*/
    goto err_label1;
    
    
  err_label2:
    {
      if(aReplySds)
      {
        /**=================================================
         * Delete the reply sds
         *================================================*/
        ix_error err1 = ix_sds_del(aReplySds);
        if(err1) err = ix_error_new(0, 0, err1, 
          "%s - ix_sds_del failed!", localFunctionName);
      };
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}

/* Definition of invoke function for logicalIfMgmt::ifAddIf operation */
extern ix_error invoke_logicalIfMgmt_ifAddIf(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_logicalIfMgmt_ifAddIf";
  static const char* localOperationName = logicalIfMgmt_ifAddIf_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    long portNum;
    long ifNum;
    char* name;
    unsigned long ipV4Addr;
    unsigned long ipV4Mask;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    name = 0;
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_long(aSds,&portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portNum!", localFunctionName);
      goto err_label1;
    };
    err = ix_sds_p_long(aSds,&ifNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for ifNum!", localFunctionName);
      goto err_label1;
    };
    err = ix_sds_p_string(aSds,&name);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for name!", localFunctionName);
      goto err_label1;
    };
    err = ix_sds_p_ulong(aSds,&ipV4Addr);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for ipV4Addr!", localFunctionName);
      goto err_label1;
    };
    err = ix_sds_p_ulong(aSds,&ipV4Mask);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for ipV4Mask!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((logicalIfMgmt_ifAddIf_fptr) pFunc)(basep, portNum, ifNum, name, ipV4Addr, ipV4Mask);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for logicalIfMgmt_ifAddIf operation failed!", localFunctionName);
      goto err_label1;
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    
    if(name != 0)
    {
      free(name);
      name = 0;
    };
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}

/* Definition of invoke function for logicalIfMgmt::ifRemoveIf operation */
extern ix_error invoke_logicalIfMgmt_ifRemoveIf(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_logicalIfMgmt_ifRemoveIf";
  static const char* localOperationName = logicalIfMgmt_ifRemoveIf_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    long portNum;
    long ifNum;
    unsigned long ipV4Addr;
    unsigned long ipV4Mask;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_long(aSds,&portNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for portNum!", localFunctionName);
      goto err_label1;
    };
    err = ix_sds_p_long(aSds,&ifNum);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for ifNum!", localFunctionName);
      goto err_label1;
    };
    err = ix_sds_p_ulong(aSds,&ipV4Addr);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for ipV4Addr!", localFunctionName);
      goto err_label1;
    };
    err = ix_sds_p_ulong(aSds,&ipV4Mask);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for ipV4Mask!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((logicalIfMgmt_ifRemoveIf_fptr) pFunc)(basep, portNum, ifNum, ipV4Addr, ipV4Mask);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for logicalIfMgmt_ifRemoveIf operation failed!", localFunctionName);
      goto err_label1;
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}


/**=================================================
 * End invoke functions definitions for interface logicalIfMgmt
 *================================================*/



/**=================================================
 * End definitions for interface logicalIfMgmt
 *================================================*/



/**=================================================
 * Start definitions for interface event
 *================================================*/


/* Server initialization function for event interface */
ix_error sk_event_init(ix_base_t* basep, ix_cap* capp)
{
  static const char localFunctionName[] = "sk_event_init";
  /* static const char* localInterfaceName = event_intName; */
  
  VMT_CrossCallEntry* pVMTCCEntry;
  CC_VMT_event* pCCVMT;
  ix_error err = 0;
  
  if(isIDLTokenInitialized(basep) != 0 )
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is already initialized!", localFunctionName);
    
    goto err_label1;
  }
  else
  {
    memset(basep, 0, sizeof(ix_base_t));
  };
  
  pCCVMT = (CC_VMT_event*) malloc(sizeof(CC_VMT_event));
  if(pCCVMT == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Crosscall VMT allocation failed!", localFunctionName);
    
    goto err_label1;
  };
  
  /* Intialize the crosscall VMT */
  
  basep->_pVMTCrossCall = pCCVMT;
  
  pCCVMT->_pCC_event_eventRegister = event_eventRegister;
  pCCVMT->_pCC_event_eventUnregister = event_eventUnregister;
  
  /* crosscall table initialization */
  basep->_vVMTCrossCallSize = sizeof(CC_VMT_event)/sizeof(idl_ixa_c_crossCall_fptr);
  pVMTCCEntry = (VMT_CrossCallEntry*) malloc(basep->_vVMTCrossCallSize * sizeof(VMT_CrossCallEntry));
  if(pVMTCCEntry == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Crosscall VMT table allocation failed!", localFunctionName);
    
    goto err_label1;
  };
  
  /* Intialize the crosscall VMT table entries */
  
  basep->_pVMTCrossCallTable = pVMTCCEntry;
  
  pVMTCCEntry->_vName = event_eventRegister_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_event_eventRegister;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_event_eventRegister;
  pVMTCCEntry++;
  
  pVMTCCEntry->_vName = event_eventUnregister_opName;
  pVMTCCEntry->_pCrossCallFuncPtr = (idl_ixa_c_crossCall_fptr*) &pCCVMT->_pCC_event_eventUnregister;
  pVMTCCEntry->_pUpcallInvokeFunc = (idl_ixa_c_upcallInvoke_fptr) invoke_event_eventUnregister;
  pVMTCCEntry++;
  
  idl_ixa_c_qsort(basep->_pVMTCrossCallTable, basep->_vVMTCrossCallSize, sizeof(VMT_CrossCallEntry), cross_call_entry_predicate);
  
  
  basep->m_pCap = capp;
  
  
  /**=================================================
   * Register the dispatch function 
   *================================================*/
  err = ix_dx_reg_dispatch(capp, /* Pointer to a ix_cap structure */
    event_intName, /* GUID of the interface */
    idl_ixa_c_dispatch, /* Dispatch function */
    (void*)basep); /* A ix_base_t* passed as a cookie */
    
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - ix_dx_reg_dispatchfailed!", localFunctionName);
    
    goto err_label1;
  };
  
  basep->_vTokenType = IDL_IXA_C_SERVER;
  basep->_pInterfaceName = event_intName;
  basep->_vInitialized = 1;
  basep->_vInitExtraCheck = isIDLTokenInitialized;
  
  /**=================================================
   * TO DO: Add your code here!!!
   *================================================*/
  
err_label1:
  if(basep->_vInitialized == 0 )
  {
    basep->_vTokenType = IDL_IXA_C_NONE;
    
    if(basep->_pVMTCrossCallTable != 0)
      free(basep->_pVMTCrossCallTable);
    basep->_vVMTCrossCallSize = 0;
    if(basep->_pVMTCrossCall != 0)
      free(basep->_pVMTCrossCall);
    
  };
  return err;
}

/* Server finalization function for event interface */
ix_error sk_event_fini(ix_base_t* basep)
{
  static const char localFunctionName[] = "sk_event_fini";
  static const char* localInterfaceName = event_intName;
  
  ix_error err = 0;
  
  if(isIDLTokenInitialized(basep) == 0 )
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is not initialized!", localFunctionName);
    
    goto err_label1;
  };
  if(basep->_vTokenType != IDL_IXA_C_SERVER)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is not of SERVER type!", localFunctionName);
    
    goto err_label1;
  };
  if(basep->_pInterfaceName != localInterfaceName)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token has not been intialized for this interface type!", localFunctionName);
    
    goto err_label1;
  };
  /**=================================================
   * TO DO: Add your code here!!!
   *================================================*/
  
  /**=================================================
   * Unregister the dispatch function 
   *================================================*/
  /*
  err = ix_dx_unreg_dispatch(event_intName);
  if(err)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Unregister function failed!", localFunctionName);
    
    goto err_label1;
  };
  */
  
  basep->_vTokenType = IDL_IXA_C_NONE;
  
  free(basep->_pVMTCrossCallTable);
  basep->_vVMTCrossCallSize = 0;
  free(basep->_pVMTCrossCall);
  memset(basep, 0, sizeof(ix_base_t));
  
err_label1:
  return err;
}

/* Accessor function for crosscall VMT */
extern ix_error getCCVMT_event(const ix_base_t* basep, CC_VMT_event** pInterfaceCCVMT)
{
  static const char localFunctionName[] = "CB_VMT_event";
  static const char* localInterfaceName = event_intName;
  
  ix_error err = 0;
  
  *pInterfaceCCVMT = 0;
  if(isIDLTokenInitialized(basep) == 0 )
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is not initialized!", localFunctionName);
    
    goto err_label1;
  };
  if(basep->_vTokenType != IDL_IXA_C_SERVER)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token is not of SERVER type!", localFunctionName);
    
    goto err_label1;
  };
  if(basep->_pInterfaceName != localInterfaceName)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Token has not been intialized for this interface type!", localFunctionName);
    
    goto err_label1;
  };
  
  *pInterfaceCCVMT = (CC_VMT_event*) basep->_pVMTCrossCall;
  
err_label1:
  return err;
}


/**=================================================
 * Start invoke functions definitions for interface event
 *================================================*/


/* Definition of invoke function for event::eventRegister operation */
extern ix_error invoke_event_eventRegister(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_event_eventRegister";
  static const char* localOperationName = event_eventRegister_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    char* aceName;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    aceName = 0;
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_string(aSds,&aceName);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for aceName!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((event_eventRegister_fptr) pFunc)(basep, aceName);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for event_eventRegister operation failed!", localFunctionName);
      goto err_label1;
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    
    if(aceName != 0)
    {
      free(aceName);
      aceName = 0;
    };
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}

/* Definition of invoke function for event::eventUnregister operation */
extern ix_error invoke_event_eventUnregister(ix_base_t* basep, ix_sds aSds, idl_ixa_c_crossCall_fptr pFunc)
{
  static const char localFunctionName[] = "invoke_event_eventUnregister";
  static const char* localOperationName = event_eventUnregister_opName;
  
  ix_error err = 0;
  (void)aSds;
  
#ifdef _IDL_OUTPUT_DEBUG
  printf("%s - Crosscall for operation %s invoked!\n",localFunctionName, localOperationName);
#endif /* _IDL_OUTPUT_DEBUG */
  
  if(pFunc == 0)
  {
    err = ix_error_new(0, 0, err, 
      "%s - Pure virtual crosscall function for %s operation!", localFunctionName, localOperationName);
    
    goto err_label3;
  };
  {
    char* aceName;
    
    /**=================================================
     * Intialize variables 
     *================================================*/
    aceName = 0;
    
    /**=================================================
     * Demarshal in and inout parameters 
     *================================================*/
    err = ix_sds_p_string(aSds,&aceName);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - argument demarshaling failed for aceName!", localFunctionName);
      goto err_label1;
    };
    
    /**=================================================
     * Make the upcall 
     *================================================*/
    err = ((event_eventUnregister_fptr) pFunc)(basep, aceName);
    if(err)
    {
      err = ix_error_new(0, 0, err, 
        "%s - crosscall for event_eventUnregister operation failed!", localFunctionName);
      goto err_label1;
    };
    
  err_label1:
    
    /**=================================================
     * Finalize variables 
     *================================================*/
    
    if(aceName != 0)
    {
      free(aceName);
      aceName = 0;
    };
    (void)localFunctionName;
    (void)localOperationName;
    
  };
err_label3:
  return err;
}


/**=================================================
 * End invoke functions definitions for interface event
 *================================================*/



/**=================================================
 * End definitions for interface event
 *================================================*/

