#include <ix/asl.h>
#include <stdio.h>
#include <stdlib.h>
#include <ingress_ace_stub_c.h>

unsigned char *getmacraddr;
static ix_task task; 
static ix_cap *capp;
ix_mutex getmacmutex;
ix_cond getmaccond;


#define CK(A) do { ix_error e; if ( (e = (A)) ) { \
                   ix_error_dump(stderr, e); return -1; } } while (0)


static ix_error ThreadRun(void *aux, void **rv)
{
  ix_error e = 0;
  (void)rv;

  ix_error_init(64, 512);
  e = ix_cap_loop(capp);

  if ( !e || ix_error_is(e, 0, IX_ERROR_STOP) )
  {
    return 0;
  }
  else
  {
    ix_error_dump(stderr, e);
    return e;
  }
}


/* get the MAC address of the port */
/* EVIL: You must do all of this to get one simple value in Intel-land */
/*       Note how long it would be if the macros were expanded and beautified */
int get_mac(char *iname, int port, unsigned char addr[6])
{
int full;
ix_base_t base;
ix_ossl_thread_t tid;

  CK(ix_task_init(&task, "FOO"));
  CK(ix_task_to_cap(&task, &capp));
  memset(&base, 0, sizeof(base));

  CK(ix_mutex_new(&getmacmutex, IX_MUTEX_UNLOCKED));
  CK(ix_cond_new(&getmaccond));

  CK(ix_ossl_create_thread(&tid, ThreadRun, &task));

  CK(stub_portMgmt_init(&base, capp));
  CK(ix_oms_connect(&base, iname));
  CK(ix_oms_wait_connected(&base));

  /* now get the MAC address */
  ix_mutex_lock(getmacmutex);
  getmacraddr = addr;
  CK(stub_portMgmt_portGetMacAddr(&base, port));
  ix_cond_wait(getmaccond, getmacmutex);
  ix_mutex_release(getmacmutex);


  CK(ix_oms_disconnect(&base));
  CK(ix_oms_wait_disconnected(&base));
  CK(stub_portMgmt_fini(&base));
  CK(ix_cap_shutdown(capp, &full));
  CK(ix_ossl_wait_for_thread(tid, 0, 0));
  CK(ix_task_fini(&task));
  CK(ix_cond_del(getmaccond));
  CK(ix_mutex_del(getmacmutex));

  return 0;
}



int set_promisc(char *iname, int port, int on)
{
int full;
ix_base_t base;
ix_ossl_thread_t tid;

  CK(ix_task_init(&task, "BAR"));
  CK(ix_task_to_cap(&task, &capp));
  memset(&base, 0, sizeof(base));

  CK(ix_ossl_create_thread(&tid, ThreadRun, &task));

  CK(stub_portMgmt_init(&base, capp));
  CK(ix_oms_connect(&base, iname));
  CK(ix_oms_wait_connected(&base));

  /* Set the port in promiscuous mode */
  if ( on )
  {
    /* fprintf(stderr, "Setting port %d in promiscuous mode!\n", port); */
    CK(stub_portMgmt_portSetPromiscMode(&base, port));
  }
  else
  {
    /* fprintf(stderr, "Setting port %d in regular mode!\n", port); */
    CK(stub_portMgmt_portClearPromiscMode(&base, port));
  }

  CK(ix_oms_disconnect(&base));
  CK(ix_oms_wait_disconnected(&base));
  CK(stub_portMgmt_fini(&base));
  CK(ix_cap_shutdown(capp, &full));
  CK(ix_ossl_wait_for_thread(tid, 0, 0));
  CK(ix_task_fini(&task));

  return 0;
}

