#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <npapi.h>
#include <reassemble.h>
#include <ip.h>

#define offsetof(type, field) ((int)(&(((type *)0)->field)))
#define DBG	fprintf(stderr, "%s:%d\n", __FILE__, __LINE__);
 
#define ETOFF	12
#define ETYPE_IP 0x800
#define FRAGOFF 20
#define NUMQ	10
#define IPHOFF	14
#define IPHLEN	20		/* Base header length */
#define MTU	1500
#define IPF_TIMEOUT	60
#define MAXDLEN (MTU - IPHOFF - IPHLEN)
#define OURIPA	0x0a000001
#define OUREA	"\x00\x01\x02\x03\x04\x05"

struct fbqueue
{ 
  struct fbuffer *buf;
  struct fbqueue *next;
  int            off;
  int            len;
  int		 islast;
} *RQueues[NUMQ];

static int RQTimeouts[NUMQ];


int onstartup(void)
{
int i;

  for ( i = 0 ; i < NUMQ ; i++ )
  {
    RQueues[i] = 0;
    RQTimeouts[i] = -1;
  }

  signal(SIGALRM, reastimer);
  alarm(1);
}



void onshutdown(void)
{ 
int i;

  alarm(0);

  for ( i = 0 ; i < NUMQ ; i++ )
    freequeue(i);
}



void freequeue(
  int i)
{
struct fbqueue *fq, *hold;

  fq = RQueues[i];
  RQueues[i] = 0;
  RQTimeouts[i] = -1;

  while ( fq ) 
  { 
    hold = fq; 
    fq = fq->next;
    free(hold->buf);
    free(hold);
  }
}



struct fbqueue *newfbq(
   struct fbuffer *buf)
{
struct fbqueue *qe;
struct ip ip;

  qe = malloc(sizeof(*qe));

  if ( qe ) 
  { 
    memmove(&ip, buf->frame + IPHOFF, IPHLEN);
    qe->buf = buf;
    qe->off = (ip.ip_fragoff & IP_FRAGOFF) << 3;
    qe->len = ip.ip_len - ((ip.ip_verlen & 0xf) << 2);
    qe->islast = !(ip.ip_fragoff & IP_MF);
    qe->next = 0;
  }

  return qe; 
}




struct fbuffer *reassemble(
   struct fbuffer *fb)
{ 
struct ip ip1, ip2;
unsigned short off, etype; 
int i, freeq = -1, gottolast, len;
struct fbqueue *qe, *t, *p;
struct fbuffer *outbuf;
unsigned char *cp, vhl;

  /* Ignore ARPs and other non-ip packets */
  etype = *(unsigned short *)(fb->frame + ETOFF);
  if ( etype != ETYPE_IP )
    return fb;

  memmove((void *)&ip1, fb->frame + IPHOFF, IPHLEN);
  memmove((void *)&ip1, fb->frame + IPHOFF, IPHLEN);
  off = ip1.ip_fragoff;

  /* If this isn't a fragment just return it */
  if ( !(off & IP_FRAGOFF) && !(off & IP_MF) )
    return fb;

  /* We have a fragment after all */
  for ( i = 0 ; i < NUMQ ; ++i ) 
  { 
    if ( !RQueues[i] ) /* Note the first empty queue. Avoid emtpy queues */
    {
      if (freeq < 0) 
        freeq = i; 
      continue;
    }

    memmove((void *)&ip2, RQueues[i]->buf->frame + IPHOFF, IPHLEN);
    if ( (ip1.ip_src == ip2.ip_src) && (ip1.ip_dst == ip2.ip_dst) &&
         (ip1.ip_id == ip2.ip_id) )
    {
      break;
    }
  } 

  if ( i < NUMQ )	/* We found other fragments for this packet */
  {

    RQTimeouts[i] = IPF_TIMEOUT;	/* First reset the timer */

    if ( !(qe = newfbq(fb)) )
    {
      free(fb);
      return 0;
    }

    /* After this loop, p points to the place to put the new fragment */
    for (p = 0, t = RQueues[i] ; t && (t->off < qe->off) ; p = t, t = t->next);

    if ( ! p ) 
    {
      qe->next = RQueues[i];
      RQueues[i] = qe; 
    }
    else
    {
      qe->next = t;
      p->next = qe; 
    }

    RQTimeouts[i] = IPF_TIMEOUT;

    /* Now check if we have completed the fragment */
    off = 0;
    gottolast = 0;
    for ( t = RQueues[i] ; t && !(t->islast) ; t = t->next ) 
    { 
      if ( t->off > off ) 
        return 0; 

      if ( t->off + t->len > off ) 
        off = t->off + t->len;
    }

    if ( !t ) 
      return 0;

    /* Now do the actual reassembly */
    len = t->off + t->len + IPHOFF + IPHLEN;
    if ( len > MTU ) 	/* illegal reassembly */
      goto done;

    outbuf = new_fbuf(len);
    if ( ! outbuf ) 
      goto done;

    
    outbuf->ifnum = t->buf->ifnum;
    outbuf->ofnum = t->buf->ofnum;
    outbuf->len = len;

    /* Copy the Ethernet header */
    memmove(outbuf->frame, t->buf->frame, IPHOFF);

    /* Copy the IP header */
    ip1.ip_len = len - IPHOFF;
    ip1.ip_fragoff = 0;
    ip1.ip_verlen = 0x45;			/* NO options */
    ip1.ip_cksum = 0;
    ip1.ip_cksum = cksum((unsigned short *)&ip1, IPHLEN);
    memmove(outbuf->frame + IPHOFF, &ip1, IPHLEN);

    /* Copy the Data */
    cp = outbuf->frame + IPHOFF + IPHLEN;
    for ( t = RQueues[i] ; t ; t = t->next ) 
    {
      vhl = *(unsigned char *)(t->buf->frame + IPHOFF);
      len = (vhl & 0xf) << 2;
      off = *(unsigned short *)(t->buf->frame + FRAGOFF);
      off = (off & IP_FRAGOFF) << 3;
      memmove(cp + off, t->buf->frame + IPHOFF + len, t->len);
      if ( t->islast )
	break;
    }

    /* Get rid of the queue */
done:
    freequeue(i);
    return outbuf;
  }
  else if ( freeq >= 0 ) /* This is for a new queue */
  { 
    if ( !(qe = newfbq(fb)) ) /* if we are out of mem, just free the fb */
      free(fb);

    RQueues[freeq] = qe;
    RQTimeouts[freeq] = IPF_TIMEOUT;
    return 0;
  }
  else	/* no match, and no free queues */
  {
    free(fb);
    return 0;
  }
}



unsigned short cksum(unsigned short *sp, int len)
{
unsigned long sum = 0;
int l, i;

  l = len / 2;

  for ( i = 0 ; i < l ; i++ )
    sum += *sp++;

  sum = (sum & 0xFFFF) + (sum >> 16);
  sum = (sum & 0xFFFF) + (sum >> 16);

  return (unsigned short)~sum;
}




void reastimer(
   int arg)
{ 
int i; 

(void)arg;

  for ( i = 0 ; i < NUMQ ; ++i ) 
    if ( (RQTimeouts[i] > 0) && !--(RQTimeouts[i]) )
    {
      sendicmptimeout(RQueues[i]->buf);
      freequeue(i);
    }

  alarm(1);
}


void sendicmptimeout(
   struct fbuffer *src)
{
struct ip ip;
struct fbuffer *fb;
unsigned short ipt = 0x800;
static int icmpid = 0;
int cdlen;
struct icmptimex
{
  unsigned char	type;
  unsigned char code;
  unsigned short cksum;
  unsigned long mbz;
  char data[8];
} icmp;

  /* Do NOT send ICMP packets for ICMP packets! */
  /* CHANGE;  can send for non-error icmp messages */
  if ( *(unsigned char *)(src->frame + 23) == 1 )
    return;

  /* Snap off up to 8 bytes of the packet */
  cdlen = (src->len - 14 > 8) ? 8 : src->len - 14;

  if ( ! (fb = new_fbuf(cdlen + IPHOFF + IPHLEN + 8)) ) 
    return;

  /* Copy the source ethernet address to the destination of the ICMP packet */
  memmove(fb->frame, src->frame + 6, 6);
  memmove(fb->frame + 6, OUREA, 6);
  memmove(fb->frame + 12, &ipt, sizeof(ipt));


  /* Build the IP header */
  ip.ip_verlen = 0x45;
  ip.ip_tos = 0;
  ip.ip_len = IPHLEN + 8 + cdlen;
  ip.ip_id = ++icmpid;
  ip.ip_fragoff = 0;
  ip.ip_ttl = 255;
  ip.ip_proto = 1; /* ICMP */
  ip.ip_cksum = 0;
  ip.ip_src = OURIPA;
  memmove(&ip.ip_dst, src->frame + 12, 4);
  ip.ip_cksum = cksum((unsigned short *)&ip, 20);
  memmove(fb->frame + IPHOFF, &ip, IPHLEN);

  /* Finally, the icmp header */
  icmp.type = 11;
  icmp.code = 1;
  icmp.cksum = 0;
  icmp.mbz = 0;
  memset(icmp.data, 0, sizeof(icmp.data));
  memmove(icmp.data, src->frame + 14, cdlen);
  icmp.cksum = cksum((unsigned short *)&icmp, 8 + cdlen);
  memmove(fb->frame + IPHOFF + IPHLEN, &icmp, 8 + cdlen);

  fb->len = ip.ip_len + IPHOFF;
  fb->ifnum = -1; 
  fb->ofnum = src->ifnum;
  send(fb);
  free(fb);
}
