#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <npapi.h>


#define NUMIF	4


struct fbuffer *reassemble(struct fbuffer *fb);
int onstartup(void);
void onshutdown(void);



void fail(char *s)
{
  fprintf(stderr, "%s\n", s);
  exit(-1);
}


void shandle(int sig)
{ 
  fprintf(stderr, "Exiting...\n");
  exit(0);
}


int main(int argc, char *argv[])
{ 
struct fbuffer *f;
int i, rv;

  onstartup();
  signal(SIGINT, shandle);
  signal(SIGTERM, shandle);

  if ( np_start(0, 0) < 0 )
    fail("Couldn't connect to network processor.");


  while ( 1 )
  {
    /* Get a buffer for a maximum sized frame */
    f = new_fbuf(1514);

    next_frame(f);

    if ( f->ifnum == 0 )
      f->ofnum = 3; 
    else if ( f->ifnum == 3 ) 
      f->ofnum = 0;
    else
    {
      fprintf(stderr, "Don't know where to send frame from if %d\n", f->ifnum);
      fail("quitting\n");
    }

    f = reassemble(f);
    if ( f ) 
    {
      send_frame(f, 0);
      free(f);
    }
  }


  if ( rv < 0 )
    fail("Error getting next frame!");

  np_stop();

  onshutdown();

  return 0;
}
