#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <npapi.h>

#define NUMIF 4

void receive(struct fbuffer *f);
void fail(char *s);
void shandle(int sig);


void fail(char *s)
{
  fprintf(stderr, "%s\n", s);
  exit(-1);
}


void shandle(int sig)
{ 
  fprintf(stderr, "Exiting...\n");
  exit(0);
}


int main(int argc, char *argv[])
{ 
char buffer[2048];
struct fbuffer *f = (struct fbuffer *)buffer;
int rv, i;

  signal(SIGINT, shandle);
  signal(SIGTERM, shandle);

  if ( np_start(0, 0) < 0 )
    fail("Couldn't connect to network processor.");


  while ( 1 )
  {
    next_frame(f);
    receive(f);
  }

  if ( rv < 0 )
    fail("Error getting next frame!");

  np_stop();

  return 0;
}
