#include <npapi.h>
#include <stdlib.h>
#include <ip.h>
#include <tcp.h>
#include <ether.h>
#include <arp.h>
#include <udp.h>
#include <icmp.h>
#include <sniff_print.h>

int print_xverbose(struct ep *pep, int len, int ifnum);


#include <setbyteorder.h>

int 
packet_ntoh(
  struct ep *pep) { 

  switch(ETYPE(pep)) {
    case  EPT_ARP :
    case  EPT_RARP :
      arp_ntoh((struct arp *)pep->ep_data); 
      break;

    case  EPT_IP:
      ip_ntoh((struct ip *)pep->ep_data);
      break;
    default:
  }
return 0;
}


int 
arp_ntoh(
  struct arp *ah)

{ 
  IPaddr ip1; 

  ah->ar_hwtype = N2HS(ah->ar_hwtype); 
  ah->ar_prtype = N2HS(ah->ar_prtype); 
  ah->ar_op = N2HS(ah->ar_op); 


  /* CHANGE :  Assues IP datagrams & 4 byte length */
  /* Change source protocol address */
  memcpy(&ip1, SPA(ah), sizeof(IPaddr)); 
  ip1 = N2HL(ip1); 
  memcpy(SPA(ah), &ip1, sizeof(IPaddr)); 

  /* Change target protocol address */
  memcpy(&ip1, TPA(ah), sizeof(IPaddr)); 
  ip1 = N2HL(ip1); 
  memcpy(TPA(ah), &ip1, sizeof(IPaddr)); 

  return 0; 
} 


int 
ip_ntoh(
  struct ip *pip)

{ 
  iph_ntoh(pip); 
  switch(pip->ip_proto){
     case IPT_ICMP :  icmp_ntoh((struct icmp *)IP_DATA(pip));  break; 
     case IPT_TCP  :  tcp_ntoh((struct tcp *)IP_DATA(pip));    break; 
     case IPT_UDP  :  udp_ntoh((struct udp *)IP_DATA(pip));    break;
  }
return 0; 
} 


int iph_ntoh(
   struct ip *pip) 
{ 
  pip->ip_len     = N2HS(pip->ip_len);
  pip->ip_id      = N2HS(pip->ip_id);
  pip->ip_fragoff = N2HS(pip->ip_fragoff);
  pip->ip_cksum   = N2HS(pip->ip_cksum);
  pip->ip_src     = N2HL(pip->ip_src); 
  pip->ip_dst     = N2HL(pip->ip_dst); 
return 0; 
} 


int icmp_ntoh(
   struct icmp *ich) 
{ 
  ich->ic_cksum = N2HS(ich->ic_cksum); 
return 0; 
} 


int tcp_ntoh(
   struct tcp *th) 
{ 
  th->t_src = N2HS(th->t_src);  
  th->t_dst = N2HS(th->t_dst);  
  th->t_seq = N2HL(th->t_seq);  
  th->t_ack = N2HL(th->t_ack);  
  th->t_window = N2HS(th->t_window);  
  th->t_cksum = N2HS(th->t_cksum);  
  th->t_urg = N2HS(th->t_urg);  
return 0; 
} 


int udp_ntoh(
   struct udp *uh) 
{ 
  uh->u_src = N2HS(uh->u_src); 
  uh->u_dst = N2HS(uh->u_dst); 
  uh->u_len = N2HS(uh->u_len); 
  uh->u_cksum = N2HS(uh->u_cksum); 
  return 0; 
} 


void receive(
   struct fbuffer *fbuf)
{
  packet_ntoh((struct ep *)fbuf->frame);
  print_xverbose((struct ep *)fbuf->frame, fbuf->len, fbuf->ifnum);
}
